/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.value_calc;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.data.stats.StatScaling;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.WeaponDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.Health;
import com.robertx22.mine_and_slash.database.data.value_calc.LeveledValue;
import com.robertx22.mine_and_slash.database.data.value_calc.MaxLevelProvider;
import com.robertx22.mine_and_slash.database.data.value_calc.ScalingCalc;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ValueCalculation
implements JsonExileRegistry<ValueCalculation>,
IAutoGson<ValueCalculation> {
    public static ValueCalculation SERIALIZER = new ValueCalculation();
    public List<ScalingCalc> stat_scalings = new ArrayList<ScalingCalc>();
    public String id = "";
    public StatScaling base_scaling_type = StatScaling.NORMAL;
    public LeveledValue base = new LeveledValue(0.0f, 0.0f);
    public ScalingCalc dmg_effectiveness = new ScalingCalc(Health.getInstance(), new LeveledValue(1.0f, 1.0f));
    public float cap_to_wep_dmg = 1000.0f;

    public List<ScalingCalc> getAllScalingValues() {
        return new ArrayList<ScalingCalc>(this.stat_scalings);
    }

    public int getCalculatedBaseValue(LivingEntity en, MaxLevelProvider provider) {
        if (this.base_scaling_type == null) {
            MMORPG.logError("base scaling type null");
            return 0;
        }
        return (int)this.base_scaling_type.scale(this.base.getValue(en, provider), Load.Unit((Entity)en).getLevel());
    }

    public float getDamageEffectiveness(LivingEntity en, MaxLevelProvider provider) {
        return this.dmg_effectiveness.getMulti().getValue(en, provider);
    }

    public String getLocDmgTooltip(Elements element) {
        return "[calc:" + this.id + "] " + element.getIconNameDmg();
    }

    public String getLocDmgTooltip() {
        return "[calc:" + this.id + "]";
    }

    private int getCalculatedScalingValue(LivingEntity en, MaxLevelProvider provider) {
        float maxotherscaling;
        Optional<ScalingCalc> opt = this.getAllScalingValues().stream().filter(x -> x.getStat() == WeaponDamage.getInstance()).findFirst();
        float dmg = 0.0f;
        if (opt.isPresent()) {
            dmg = opt.get().getCalculatedValue(en, provider);
        }
        float other = 0.0f;
        other += (float)this.getAllScalingValues().stream().filter(x -> x.getStat() != WeaponDamage.getInstance()).mapToInt(x -> x.getCalculatedValue(en, provider)).sum();
        if (this.capsToWeaponDamage() && other > (maxotherscaling = dmg * this.cap_to_wep_dmg)) {
            other = maxotherscaling;
        }
        float amount = other + dmg;
        return (int)amount;
    }

    public int getCalculatedValue(LivingEntity en, MaxLevelProvider provider) {
        int val = this.getCalculatedScalingValue(en, provider);
        return val += this.getCalculatedBaseValue(en, provider);
    }

    public Component getShortTooltip(LivingEntity en, MaxLevelProvider provider) {
        Optional<ScalingCalc> opt;
        MutableComponent text = Component.m_237113_((String)"");
        int val = this.getCalculatedValue(en, provider);
        text.m_130946_("" + ChatFormatting.GREEN + val + ChatFormatting.GRAY);
        if (!Screen.m_96638_()) {
            return text;
        }
        this.stat_scalings.forEach(x -> text.m_130946_(" ").m_7220_(x.GetTooltipString(en, provider)));
        if (this.capsToWeaponDamage() && (opt = this.getAllScalingValues().stream().filter(x -> x.getStat() == WeaponDamage.getInstance()).findFirst()).isPresent()) {
            int num = (int)(opt.get().getMulti().getValue(en, provider) * 100.0f * this.cap_to_wep_dmg);
            text.m_7220_((Component)Words.CAPPED_TO_WEP_DMG.locName(num));
        }
        return text;
    }

    public boolean capsToWeaponDamage() {
        return this.cap_to_wep_dmg < 50.0f;
    }

    public Class<ValueCalculation> getClassForSerialization() {
        return ValueCalculation.class;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.VALUE_CALC;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return 1000;
    }
}

