/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.talent_tree.parser;

import com.robertx22.library_of_exile.utils.Watch;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.database.data.talent_tree.parser.GridPoint;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TalentGrid {
    TalentTree school;
    List<List<GridPoint>> grid = new ArrayList<List<GridPoint>>();

    public GridPoint get(int x, int y) {
        return this.grid.get(x).get(y);
    }

    public TalentGrid(TalentTree school, String str) {
        this.school = school;
        int y = 0;
        for (String line : str.split("\n")) {
            int x = 0;
            for (String s : line.split(",")) {
                if (this.grid.size() <= x) {
                    this.grid.add(new ArrayList());
                }
                this.grid.get(x).add(new GridPoint(x, y, s));
                ++x;
            }
            ++y;
        }
    }

    public void loadIntoTree() {
        ArrayList<GridPoint> perks = new ArrayList<GridPoint>();
        Watch gridwatch = new Watch().min(500);
        for (List<GridPoint> list : this.grid) {
            for (GridPoint point : list) {
                if (point.isTalent) {
                    this.school.calcData.addPerk(point.getPoint(), point.getId());
                    perks.add(point);
                    continue;
                }
                if (!point.isCenter) continue;
                this.school.calcData.center = point.getPoint();
            }
        }
        gridwatch.print(" Setting up talent grid ");
        Objects.requireNonNull(this.school.calcData.center, "Tree needs a center!");
        Watch fast2 = new Watch().min(1);
        perks.forEach(one -> {
            Set<String> connectorTypes = this.getConnectorTypes((GridPoint)one);
            perks.forEach(two -> {
                if (!this.school.calcData.isConnected(one.getPoint(), two.getPoint()) && one.isInDistanceOf((GridPoint)two) && this.hasPath((GridPoint)one, (GridPoint)two, connectorTypes)) {
                    this.school.calcData.addConnection(one.getPoint(), two.getPoint());
                }
            });
        });
        fast2.print(" Connecting talent tree ");
    }

    private boolean hasPath(GridPoint start, GridPoint end, Set<String> connectorTypes) {
        for (String connector : connectorTypes) {
            ArrayDeque<GridPoint> openSet = new ArrayDeque<GridPoint>();
            openSet.add(start);
            HashSet<GridPoint> closedSet = new HashSet<GridPoint>();
            while (!openSet.isEmpty()) {
                GridPoint current = (GridPoint)openSet.poll();
                if (!closedSet.add(current)) continue;
                if (current.equals(end)) {
                    return true;
                }
                if (current.isTalent && current != start) continue;
                openSet.addAll(this.getEligibleSurroundingPoints(current, connector));
            }
        }
        return false;
    }

    Set<String> getConnectorTypes(GridPoint p) {
        HashSet<String> set = new HashSet<String>();
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                GridPoint c = this.get(p.x + x, p.y + y);
                if (!c.isConnector) continue;
                set.add(c.getId());
            }
        }
        return set;
    }

    public Set<GridPoint> getEligibleSurroundingPoints(GridPoint p, String connector) {
        HashSet<GridPoint> set = new HashSet<GridPoint>();
        int x = p.x;
        int y = p.y;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dx == 0 && dy == 0) continue;
                GridPoint point = this.get(x + dx, y + dy);
                if (Math.abs(dx) == 1 && Math.abs(dy) == 1 && (this.get((int)(x + dx), (int)y).isTalent || this.get((int)x, (int)(y + dy)).isTalent)) continue;
                if (point.isTalent) {
                    set.add(point);
                    continue;
                }
                if (!point.isConnector || !point.getId().equals(connector)) continue;
                set.add(point);
            }
        }
        return set;
    }
}

