/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.talent_tree.parser;

import com.google.common.hash.HashCode;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import java.util.Locale;

public class GridPoint {
    static int MAX_DISTANCE = 12;
    public final int x;
    public final int y;
    private final String id;
    boolean isTalent = false;
    boolean isConnector = false;
    boolean isCenter = false;
    private final PointData point;
    public static String CENTER_ID = "[CENTER]";

    public String getId() {
        return this.id;
    }

    public GridPoint(int x, int y, String str) {
        this.x = x;
        this.y = y;
        this.id = str.toLowerCase(Locale.ROOT);
        this.point = new PointData(x, y);
        if (this.id.length() == 1) {
            this.isConnector = true;
        } else if (this.id.equalsIgnoreCase(CENTER_ID)) {
            this.isCenter = true;
        } else if (this.id.length() > 2) {
            this.isTalent = true;
        }
    }

    public boolean isInDistanceOf(GridPoint other) {
        return Math.abs(this.x - other.x) < MAX_DISTANCE && Math.abs(this.y - other.y) < MAX_DISTANCE;
    }

    public PointData getPoint() {
        return this.point;
    }

    public int hashCode() {
        return HashCode.fromInt((int)this.x).hashCode() + HashCode.fromInt((int)this.y).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GridPoint) {
            GridPoint other = (GridPoint)obj;
            return other.x == this.x && other.y == this.y;
        }
        return false;
    }
}

