/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.talent_tree;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.stats.types.UnknownStat;
import com.robertx22.mine_and_slash.database.data.talent_tree.parser.TalentGrid;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class TalentTree
implements JsonExileRegistry<TalentTree>,
IAutoGson<TalentTree> {
    public static TalentTree EMPTY = new TalentTree();
    public static TalentTree SERIALIZER = new TalentTree();
    public int order = 0;
    public String text_format;
    public String identifier = "unknown";
    public String school_type;
    public String icon;
    public String perks = "";
    public transient CalcData calcData = new CalcData();

    public SchoolType getSchool_type() {
        try {
            return SchoolType.valueOf(this.school_type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return SchoolType.TALENTS;
        }
    }

    public Class<TalentTree> getClassForSerialization() {
        return TalentTree.class;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.TALENT_TREE;
    }

    public int Weight() {
        return 1000;
    }

    public String GUID() {
        return this.identifier;
    }

    public void onLoadedFromJson() {
        TalentGrid grid = new TalentGrid(this, this.perks);
        grid.loadIntoTree();
    }

    public boolean isRegistryEntryValid() {
        return true;
    }

    public boolean shouldGenerateJson() {
        return false;
    }

    private /* synthetic */ void lambda$isRegistryEntryValid$2(Perk x) {
        if (this.calcData.perks.values().stream().noneMatch(e -> x.GUID().equals(e))) {
            System.out.print("\n" + x.GUID() + " is registered but not used in the tree \n");
        }
    }

    private static /* synthetic */ boolean lambda$isRegistryEntryValid$0(Perk x) {
        return x.type == Perk.PerkType.SPECIAL;
    }

    public static class CalcData {
        public PointData center;
        public transient HashMap<PointData, Set<PointData>> connections = new HashMap();
        public transient HashMap<PointData, String> perks = new HashMap();

        public Perk getPerk(PointData point) {
            if (ExileDB.Perks().isRegistered(this.perks.get(point))) {
                return (Perk)ExileDB.Perks().get(this.perks.get(point));
            }
            return (Perk)ExileDB.Perks().get(new UnknownStat().GUID());
        }

        public boolean isConnected(PointData one, PointData two) {
            if (!this.connections.containsKey(one)) {
                return false;
            }
            return this.connections.get(one).contains(two);
        }

        public void addPerk(PointData point, String perk) {
            this.perks.put(point, perk);
        }

        public void addConnection(PointData from, PointData to) {
            if (from.x == to.x && from.y == to.y) {
                return;
            }
            if (!this.connections.containsKey(from)) {
                this.connections.put(from, new HashSet());
            }
            if (!this.connections.containsKey(to)) {
                this.connections.put(to, new HashSet());
            }
            this.connections.get(from).add(to);
            this.connections.get(to).add(from);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SchoolType {
        TALENTS{

            @Override
            public PlayerPointsType getPointType() {
                return PlayerPointsType.TALENTS;
            }
        }
        ,
        ASCENDANCY{

            @Override
            public PlayerPointsType getPointType() {
                return PlayerPointsType.ASCENDANCY;
            }
        };


        public abstract PlayerPointsType getPointType();
    }
}

