/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.types.summon;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.data.spells.summons.entity.golems.GolemSummon;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.priority.StatPriority;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectEvent;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class GolemSpellChance
extends Stat {
    private GolemSpellChance() {
        this.format = ChatFormatting.AQUA.m_126666_();
        this.statEffect = new GolemSpellEffect();
    }

    public static GolemSpellChance getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public boolean IsPercent() {
        return true;
    }

    @Override
    public Elements getElement() {
        return null;
    }

    @Override
    public String locDescForLangFile() {
        return "Bonus Chance for golems to cast their AOE nova spells";
    }

    public String GUID() {
        return "golem_spell_chance";
    }

    @Override
    public String locNameForLangFile() {
        return "Golem Spell Chance";
    }

    static class GolemSpellEffect
    implements IStatEffect {
        GolemSpellEffect() {
        }

        @Override
        public boolean worksOnEvent(EffectEvent ev) {
            return ev instanceof DamageEvent;
        }

        @Override
        public EffectSides Side() {
            return EffectSides.Source;
        }

        @Override
        public StatPriority GetPriority() {
            return StatPriority.Spell.FIRST;
        }

        @Override
        public void TryModifyEffect(EffectEvent effect, EffectSides statSource, StatData data, Stat stat) {
            if (effect instanceof DamageEvent) {
                GolemSummon sum;
                DamageEvent dmg = (DamageEvent)effect;
                LivingEntity livingEntity = dmg.petEntity;
                if (livingEntity instanceof GolemSummon && !Load.Unit((Entity)(sum = (GolemSummon)livingEntity)).getCooldowns().isOnCooldown("golem_spell")) {
                    Load.Unit((Entity)sum).getCooldowns().setOnCooldown("golem_spell", 20);
                    int chance = (int)effect.sourceData.getUnit().getCalculatedStat(GolemSpellChance.getInstance()).getValue();
                    if (RandomUtils.roll((int)chance)) {
                        Spell spell = (Spell)ExileDB.Spells().get(sum.aoeSpell());
                        SpellCastContext c = new SpellCastContext(effect.source, 0, spell);
                        spell.getAttached().onCast(SpellCtx.onCast(effect.source, c.calcData).setSourceEntity((Entity)sum));
                    }
                }
            }
        }
    }

    private static class SingletonHolder {
        private static final GolemSpellChance INSTANCE = new GolemSpellChance();

        private SingletonHolder() {
        }
    }
}

