/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.types.ailment;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.Ailment;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.StatGuiGroup;
import com.robertx22.mine_and_slash.database.data.stats.effects.base.BaseDamageEffect;
import com.robertx22.mine_and_slash.database.data.stats.priority.StatPriority;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EventBuilder;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.enumclasses.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import net.minecraft.world.entity.Entity;

public class AilmentChance
extends Stat {
    Ailment ailment;

    public AilmentChance(Ailment ailment) {
        this.ailment = ailment;
        this.is_perc = true;
        this.statEffect = new Effect();
        this.min = 0.0f;
        this.max = 100.0f;
        this.gui_group = StatGuiGroup.AILMENT_CHANCE;
    }

    @Override
    public Elements getElement() {
        return this.ailment.element;
    }

    @Override
    public String locDescForLangFile() {
        return "Chance to Cause the Ailment on hit. Maximum chance is 100%. " + this.ailment.locDescForLangFile();
    }

    @Override
    public String locNameForLangFile() {
        return this.ailment.locNameForLangFile() + " Chance";
    }

    public String GUID() {
        return this.ailment.GUID() + "_chance";
    }

    private class Effect
    extends BaseDamageEffect {
        private Effect() {
        }

        @Override
        public StatPriority GetPriority() {
            return StatPriority.Spell.FIRST;
        }

        @Override
        public EffectSides Side() {
            return EffectSides.Source;
        }

        @Override
        public DamageEvent activate(DamageEvent effect, StatData data, Stat stat) {
            float dmg = effect.data.getOriginalNumber((String)EventData.NUMBER).number;
            if (dmg <= 0.0f) {
                return effect;
            }
            DamageEvent event = EventBuilder.ofDamage(effect.source, effect.target, dmg).setupDamage(AttackType.dot, WeaponTypes.none, PlayStyle.INT).set(x -> {
                x.disableActivation = true;
                x.setElement(AilmentChance.this.ailment.element);
                x.setisAilmentDamage(AilmentChance.this.ailment);
                if (effect.isSpell()) {
                    x.data.setString(EventData.SPELL, effect.data.getString(EventData.SPELL));
                }
            }).build();
            event.Activate();
            Load.Unit((Entity)effect.target).ailments.onAilmentCausingDamage(effect.source, effect.target, AilmentChance.this.ailment, event.data.getNumber());
            return effect;
        }

        @Override
        public boolean canActivate(DamageEvent effect, StatData data, Stat stat) {
            return effect.getElement() != null && effect.getElement() == AilmentChance.this.ailment.element && effect.getAttackType().isHit() && RandomUtils.roll((float)data.getValue());
        }
    }
}

