/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.name_regex;

import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.name_regex.BasicStatRegex;
import com.robertx22.mine_and_slash.database.data.stats.name_regex.JustNameRegex;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.localization.Formatter;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.StringUTIL;
import net.minecraft.ChatFormatting;

public abstract class StatNameRegex {
    public static StatNameRegex BASIC = new BasicStatRegex();
    public static StatNameRegex JUST_NAME = new JustNameRegex();
    public static String VALUE = "[VALUE]";
    public static String PLUS_MINUS = "[PLUS_MINUS]";
    public static String NAME = "[STAT_NAME]";
    public boolean addPlus = true;
    public static String VALUEAndNAMESeparator = " ";
    private static String NORMAL_LOOK = PLUS_MINUS + VALUE + " " + NAME;
    private static String PRIMARY_STAT = NAME + ": " + VALUE;
    private static String JUST_NAME_STAT = NAME;

    public ChatFormatting statColor(Stat stat) {
        return ChatFormatting.GRAY;
    }

    public ChatFormatting numberColor(ChatFormatting format, Stat stat, float val) {
        if (format != null) {
            return format;
        }
        if (stat.minus_is_good) {
            if (val > 0.0f) {
                return ChatFormatting.RED;
            }
            return ChatFormatting.GREEN;
        }
        if (val > 0.0f) {
            return ChatFormatting.GREEN;
        }
        return ChatFormatting.RED;
    }

    public abstract String getStatNameRegex(ChatFormatting var1, ModType var2, Stat var3, float var4);

    public String translate(ChatFormatting format, TooltipStatWithContext ctx, ModType type, float v1, Stat stat) {
        String plusminus = v1 > 0.0f && this.addPlus ? "+" : "";
        String perc = "";
        if (type.isPercent() || stat.IsPercent()) {
            perc = "%";
        }
        String add = "";
        if (type == ModType.MORE) {
            add = v1 > 0.0f ? stat.getMultiUseType().prefixWord.locName().getString() : stat.getMultiUseType().prefixLessWord.locName().getString();
        }
        String v1s = NumberUtils.formatForTooltip(v1);
        if (ctx != null && !ctx.showNumber) {
            v1s = "";
            plusminus = "";
            perc = "";
        }
        if (stat.is_long) {
            String txt = stat.locName().getString();
            txt = txt.replace(Stat.VAL1, plusminus + v1s);
            return txt;
        }
        Object str = this.statColor(stat) + this.getStatNameRegex(format, type, stat, v1);
        str = ((String)str).replace(VALUE, this.numberColor(format, stat, v1) + plusminus + v1s + perc + VALUEAndNAMESeparator + ChatFormatting.RESET + this.statColor(stat));
        String[] processedReplacement = StringUTIL.joinWithoutEmpty(add, stat.locName().getString());
        str = ((String)str).replace(NAME, Formatter.SPECIAL_CALC_STAT.locName(processedReplacement).getString());
        str = Stat.format((String)str);
        return str;
    }
}

