/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.layers;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.data.stats.layers.StatLayerData;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectEvent;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class StatLayer
implements JsonExileRegistry<StatLayer>,
IAutoGson<StatLayer>,
IAutoLocName {
    public static StatLayer SERIALIZER = new StatLayer();
    public static List<StatLayer> ALL = new ArrayList<StatLayer>();
    public String id = "";
    public String name = "";
    public int priority = 0;
    public float min_multi = -1.0f;
    public float max_multi = 1000.0f;
    public LayerAction action = LayerAction.MULTIPLY;

    private StatLayer() {
    }

    public MutableComponent getTooltip(StatLayerData data) {
        MutableComponent sourcetarget = Component.m_237119_().m_130946_("[").m_7220_((Component)data.side.word.locName().m_130946_("]: "));
        MutableComponent number = Component.m_237113_((String)("x" + MMORPG.DECIMAL_FORMAT.format(data.getMultiplier())));
        if (this.action == LayerAction.ADD) {
            String plusminus = data.getNumber() < 0.0f ? "" : "+";
            number = Component.m_237113_((String)(plusminus + MMORPG.DECIMAL_FORMAT.format(data.getNumber())));
        }
        MutableComponent t = Component.m_237119_().m_7220_((Component)sourcetarget).m_7220_((Component)this.locName().m_130946_(": ").m_7220_((Component)number));
        return t;
    }

    public StatLayer(String id, String name, LayerAction action, int priority, float min_multi, float max_multi) {
        this.id = id;
        this.action = action;
        this.name = name;
        this.priority = priority;
        this.min_multi = min_multi;
        this.max_multi = max_multi;
        ALL.add(this);
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.STAT_LAYER;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.stat_layer." + this.id;
    }

    @Override
    public String locNameForLangFile() {
        return this.name;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.STAT_LAYER;
    }

    public Class<StatLayer> getClassForSerialization() {
        return StatLayer.class;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return 1000;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum LayerAction {
        MULTIPLY{

            @Override
            public void apply(EffectEvent event, StatLayerData layer, String number) {
                float multi = layer.getMultiplier();
                event.data.getNumber((String)number).number *= multi;
            }
        }
        ,
        ADD{

            @Override
            public void apply(EffectEvent event, StatLayerData layer, String number) {
                event.data.getNumber((String)number).number += layer.getNumber();
            }
        };


        public abstract void apply(EffectEvent var1, StatLayerData var2, String var3);
    }
}

