/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stat_compat;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.data.stats.StatScaling;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.stats.AttributeStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.mixin_ducks.IDirty;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class StatCompat
implements JsonExileRegistry<StatCompat>,
IAutoGson<StatCompat> {
    public static StatCompat SERIALIZER = new StatCompat();
    public String id = "";
    public String attribute_id = "";
    public String enchant_id = "";
    public StatScaling scaling = StatScaling.NONE;
    public String mns_stat_id = "";
    public float conversion = 0.5f;
    public int minimum_cap = 0;
    public int maximum_cap = 100;
    public ModType mod_type = ModType.PERCENT;

    public StatCompat(String id) {
        this.id = id + "_compat";
    }

    private StatCompat() {
    }

    public void editAndReg(Consumer<StatCompat> co) {
        co.accept(this);
        this.addToSerializables();
    }

    private Attribute getAttribute() {
        return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(this.attribute_id));
    }

    public boolean isAttributeCompat() {
        return !this.attribute_id.isEmpty();
    }

    public boolean isEnchantCompat() {
        return !this.enchant_id.isEmpty();
    }

    public ExactStatData getEnchantCompatResult(ItemStack stack, int lvl) {
        if (ExileDB.Stats().get(this.mns_stat_id) instanceof AttributeStat) {
            return null;
        }
        Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(this.enchant_id));
        int enchlvl = stack.getEnchantmentLevel(ench);
        if (enchlvl < 1) {
            return null;
        }
        int val = (int)((float)enchlvl * this.conversion);
        int value = MathHelper.clamp(val, this.minimum_cap, this.maximum_cap);
        if (value != 0) {
            value = (int)this.scaling.scale(value, lvl);
            ExactStatData data = ExactStatData.noScaling(value, this.mod_type, this.mns_stat_id);
            return data;
        }
        return null;
    }

    public ExactStatData getResult(LivingEntity en, int lvl) {
        try {
            if (ExileDB.Stats().get(this.mns_stat_id) instanceof AttributeStat) {
                return null;
            }
            int val = (int)(en.m_21133_(this.getAttribute()) * (double)this.conversion);
            int value = MathHelper.clamp(val, this.minimum_cap, this.maximum_cap);
            if (value != 0) {
                value = (int)this.scaling.scale(value, lvl);
                ExactStatData data = ExactStatData.noScaling(value, this.mod_type, this.mns_stat_id);
                return data;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void onTick(LivingEntity en) {
        IDirty check = (IDirty)en.m_21204_();
        if (check.isAttribDirty()) {
            check.setAttribDirty(false);
            Load.Unit((Entity)en).gear.setDirty();
        }
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.STAT_COMPAT;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return 1;
    }

    public Class<StatCompat> getClassForSerialization() {
        return StatCompat.class;
    }
}

