/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.summons.entity;

import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.library_of_exile.utils.geometry.MyPosition;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.database.data.spells.components.ProjectileCastHelper;
import com.robertx22.mine_and_slash.database.data.spells.entities.AutoAimingProj;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashEntities;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class SummonEntity
extends TamableAnimal
implements RangedAttackMob {
    Goal aggroGoal = null;
    public Entity focusEntity = null;

    public SummonEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }

    public void m_8119_() {
        LivingEntity owner;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.f_19797_ == 20 && (owner = this.m_269323_()) instanceof Player) {
            Player p = (Player)owner;
            if (Load.player((Player)p).config.isConfigEnabled(PlayerConfigData.Config.AGGRESSIVE_SUMMONS) && this.aggroGoal == null) {
                this.aggroGoal = new NearestAttackableTargetGoal((Mob)this, Monster.class, false);
                this.f_21346_.m_25352_(2, this.aggroGoal);
            }
        }
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        this.autoAimingRangedAttack(pTarget);
    }

    private void autoAimingRangedAttack(LivingEntity target) {
        SoundUtils.playSound((Entity)this, (SoundEvent)SoundEvents.f_11687_, (float)1.0f, (float)0.2f);
        AutoAimingProj en = (AutoAimingProj)SlashEntities.AUTO_AIMING_SKELETON_SKULL.get().m_20615_(this.m_9236_());
        en.m_5602_((Entity)this);
        en.m_20343_(this.m_20185_(), this.m_20188_(), this.m_20189_());
        en.m_20256_(ProjectileCastHelper.positionToVelocity(new MyPosition(this.m_146892_()), new MyPosition(target.m_146892_())));
        en.target = target;
        en.speed = 2.0f;
        this.m_9236_().m_7967_((Entity)en);
    }

    public boolean usesMelee() {
        return true;
    }

    public boolean usesRanged() {
        return false;
    }

    protected void m_8099_() {
        if (this.usesMelee()) {
            this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        }
        if (this.usesRanged()) {
            this.f_21345_.m_25352_(5, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 15.0f));
        }
        this.f_21345_.m_25352_(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1));
        this.f_21345_.m_25352_(7, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 6.0f, 1.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(4, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public boolean m_6779_(LivingEntity pTarget) {
        LivingEntity owner = this.m_269323_();
        if (owner == null) {
            return false;
        }
        if (!pTarget.m_6084_()) {
            return false;
        }
        if (AllyOrEnemy.allies.is((Entity)owner, pTarget)) {
            return false;
        }
        if (this.focusEntity != null && this.focusEntity.m_6084_() && this.isInAggroRadius((LivingEntity)this.focusEntity)) {
            return this.focusEntity == pTarget;
        }
        return this.isInAggroRadius(pTarget);
    }

    private boolean isInAggroRadius(LivingEntity target) {
        int aggroRadius = Load.Unit((Entity)this).summonedPetData.aggro_radius;
        int distance = (int)target.m_20270_((Entity)this);
        return aggroRadius >= distance;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    private static /* synthetic */ boolean lambda$performRangedAttack$0(Item item) {
        return item instanceof BowItem;
    }
}

