/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.conditions;

import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.EffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.Arrays;
import net.minecraft.world.entity.Entity;

public class IsNotOnCooldownCondition
extends EffectCondition {
    public IsNotOnCooldownCondition() {
        super(Arrays.asList(MapField.CHANCE));
    }

    @Override
    public boolean canActivate(SpellCtx ctx, MapHolder data) {
        try {
            if (ctx.target == null) {
                return false;
            }
            String id = data.get(MapField.COOLDOWN_ID);
            return !Load.Unit((Entity)ctx.target).getCooldowns().isOnCooldown(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public MapHolder create(String id) {
        MapHolder d = new MapHolder();
        d.type = this.GUID();
        d.put(MapField.COOLDOWN_ID, id);
        return d;
    }

    public String GUID() {
        return "is_not_on_cd";
    }
}

