/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity;

import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SoundAction
extends SpellAction {
    public SoundAction() {
        super(Arrays.asList(MapField.SOUND, MapField.PITCH, MapField.VOLUME));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        if (!ctx.world.f_46443_) {
            float pitch = data.get(MapField.PITCH).floatValue();
            float volume = data.get(MapField.VOLUME).floatValue();
            SoundEvent sound = data.getSound();
            SoundUtils.playSound((Level)ctx.world, (BlockPos)ctx.getBlockPos(), (SoundEvent)sound, (float)volume, (float)pitch);
        }
    }

    public MapHolder create(SoundEvent sound, Double volume, Double pitch) {
        MapHolder d = new MapHolder();
        d.type = this.GUID();
        d.put(MapField.VOLUME, volume);
        d.put(MapField.PITCH, pitch);
        d.put(MapField.SOUND, BuiltInRegistries.f_256894_.m_7981_((Object)sound).toString());
        return d;
    }

    public String GUID() {
        return "sound";
    }
}

