/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity;

import com.robertx22.library_of_exile.utils.geometry.MyPosition;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ParticleShape {
    CIRCLE{

        @Override
        public MyPosition getPosition(MyPosition middle, float radius, float angleMulti) {
            double x = middle.f_82479_;
            double y = middle.f_82480_;
            double z = middle.f_82481_;
            double radModX = Math.random();
            double radModY = Math.random();
            double radModZ = Math.random();
            double u = Math.random();
            double v = Math.random();
            double theta = Math.PI * 2 * u;
            double phi = Math.acos(2.0 * v - 1.0);
            double xpos = x + radModX * (double)radius * Math.sin(phi) * Math.cos(theta);
            double ypos = y + radModY * (double)radius * Math.sin(phi) * Math.sin(theta);
            double zpos = z + radModZ * (double)radius * Math.cos(phi);
            return new MyPosition(xpos, ypos, zpos);
        }
    }
    ,
    CIRCLE_EDGE{

        @Override
        public MyPosition getPosition(MyPosition middle, float radius, float angleMulti) {
            double x = middle.f_82479_;
            double y = middle.f_82480_;
            double z = middle.f_82481_;
            double u = Math.random();
            double v = Math.random();
            double theta = Math.PI * 2 * u;
            double phi = Math.acos(2.0 * v - 1.0);
            double xpos = x + (double)radius * Math.sin(phi) * Math.cos(theta);
            double ypos = y + (double)radius * Math.sin(phi) * Math.sin(theta);
            double zpos = z + (double)radius * Math.cos(phi);
            return new MyPosition(xpos, ypos, zpos);
        }
    }
    ,
    CIRCLE_2D{

        @Override
        public MyPosition getPosition(MyPosition middle, float radius, float angleMulti) {
            double x = middle.f_82479_;
            double y = middle.f_82480_;
            double z = middle.f_82481_;
            double u = Math.random();
            double v = Math.random();
            double theta = Math.PI * 2 * u;
            double phi = Math.acos(2.0 * v - 1.0);
            double xpos = x + (double)radius * Math.sin(phi) * Math.cos(theta);
            double zpos = z + (double)radius * Math.cos(phi);
            return new MyPosition(xpos, y, zpos);
        }
    }
    ,
    CIRCLE_2D_EDGE{

        @Override
        public MyPosition getPosition(MyPosition middle, float radius, float angleMulti) {
            double x = middle.f_82479_;
            double y = middle.f_82480_;
            double z = middle.f_82481_;
            double angle = (double)angleMulti * Math.PI * 2.0;
            double xpos = x + Math.cos(angle) * (double)radius;
            double zpos = z + Math.sin(angle) * (double)radius;
            return new MyPosition(xpos, y, zpos);
        }
    };


    public abstract MyPosition getPosition(MyPosition var1, float var2, float var3);
}

