/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.ProjectileCastHelper;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.PositionSource;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashEntities;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class SummonProjectileAction
extends SpellAction {
    public SummonProjectileAction() {
        super(Arrays.asList(MapField.ENTITY_NAME, MapField.PROJECTILE_COUNT, MapField.ITEM, MapField.PROJECTILE_SPEED, MapField.LIFESPAN_TICKS));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        if (ctx.world.f_46443_) {
            return;
        }
        Optional projectile = EntityType.m_20632_((String)data.get(MapField.PROJECTILE_ENTITY));
        PositionSource posSource = data.getOrDefault(PositionSource.CASTER);
        ShootWay shootWay = data.getOrDefault(ShootWay.FROM_PLAYER_VIEW);
        Vec3 pos = ctx.getPos();
        boolean silent = data.getOrDefault(MapField.IS_SILENT, false);
        ProjectileCastHelper builder = new ProjectileCastHelper(ctx, pos, data, ctx.caster, (EntityType)projectile.get(), ctx.calculatedSpellData);
        builder.projectilesAmount = (int)(data.get(MapField.PROJECTILE_COUNT) + (double)ctx.calculatedSpellData.data.getNumber((String)EventData.BONUS_PROJECTILES, (float)0.0f).number);
        builder.silent = silent;
        builder.shootSpeed = data.get(MapField.PROJECTILE_SPEED).floatValue();
        builder.shootSpeed *= ctx.calculatedSpellData.data.getNumber((String)EventData.PROJECTILE_SPEED_MULTI, (float)1.0f).number;
        builder.apart = data.getOrDefault(MapField.PROJECTILES_APART, 75.0).floatValue();
        if (posSource == PositionSource.SOURCE_ENTITY) {
            builder.pitch = ctx.sourceEntity.m_146909_();
            builder.yaw = ctx.sourceEntity.m_146908_();
        }
        if (shootWay == ShootWay.DOWN) {
            builder.fallDown = true;
        }
        if (shootWay == ShootWay.FIND_ENEMY) {
            builder.targetEnemy = true;
        }
        builder.cast();
    }

    public MapHolder create(Item item, Double projCount, Double speed, EntityType type, Double lifespan, boolean gravity) {
        MapHolder c = new MapHolder();
        c.put(MapField.PROJECTILE_COUNT, projCount);
        c.put(MapField.ENTITY_NAME, Spell.DEFAULT_EN_NAME);
        c.put(MapField.PROJECTILE_SPEED, speed);
        c.put(MapField.LIFESPAN_TICKS, lifespan);
        c.put(MapField.ITEM, VanillaUTIL.REGISTRY.items().getKey((Object)item).toString());
        c.put(MapField.GRAVITY, gravity);
        c.put(MapField.PROJECTILE_ENTITY, EntityType.m_20613_((EntityType)type).toString());
        c.type = this.GUID();
        return c;
    }

    public MapHolder create(Item item, Double speed, EntityType type, Double lifespan) {
        MapHolder c = new MapHolder();
        c.put(MapField.PROJECTILE_COUNT, 1.0);
        c.put(MapField.ENTITY_NAME, Spell.DEFAULT_EN_NAME);
        c.put(MapField.PROJECTILE_SPEED, speed);
        c.put(MapField.LIFESPAN_TICKS, lifespan);
        c.put(MapField.ITEM, VanillaUTIL.REGISTRY.items().getKey((Object)item).toString());
        c.put(MapField.GRAVITY, true);
        c.put(MapField.PROJECTILE_ENTITY, EntityType.m_20613_((EntityType)type).toString());
        c.type = this.GUID();
        return c;
    }

    public MapHolder createArrow(Double projCount) {
        MapHolder c = this.createBase(projCount, 3.0, 80.0, true);
        c.put(MapField.PROJECTILE_ENTITY, EntityType.m_20613_(SlashEntities.SIMPLE_ARROW.get()).toString());
        return c;
    }

    public MapHolder createFallingArrow(Double speed) {
        MapHolder c = this.createBase(1.0, speed, 60.0, true);
        c.put(MapField.PROJECTILE_ENTITY, EntityType.m_20613_(SlashEntities.SIMPLE_ARROW.get()).toString());
        c.put(MapField.POS_SOURCE, PositionSource.SOURCE_ENTITY.name());
        c.put(MapField.SHOOT_DIRECTION, ShootWay.DOWN.name());
        return c;
    }

    public MapHolder createTrident(Double projCount, Double speed, Double lifespan) {
        MapHolder c = this.createBase(projCount, speed, lifespan, true);
        c.put(MapField.PROJECTILE_ENTITY, EntityType.m_20613_(SlashEntities.SIMPLE_TRIDENT.get()).toString());
        return c;
    }

    private MapHolder createBase(Double projCount, Double speed, Double lifespan, boolean gravity) {
        MapHolder c = new MapHolder();
        c.put(MapField.PROJECTILE_COUNT, projCount);
        c.put(MapField.ENTITY_NAME, Spell.DEFAULT_EN_NAME);
        c.put(MapField.PROJECTILE_SPEED, speed);
        c.put(MapField.LIFESPAN_TICKS, lifespan);
        c.put(MapField.ITEM, VanillaUTIL.REGISTRY.items().getKey((Object)Items.f_41852_).toString());
        c.put(MapField.GRAVITY, gravity);
        c.type = this.GUID();
        return c;
    }

    public String GUID() {
        return "projectile";
    }

    public static enum ShootWay {
        FROM_PLAYER_VIEW,
        DOWN,
        FIND_ENEMY;

    }
}

