/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.mine_and_slash.aoe_data.database.spells.SummonType;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.spells.summons.entity.SummonEntity;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;

public class SummonPetAction
extends SpellAction {
    public SummonPetAction() {
        super(Arrays.asList(new MapField[0]));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        if (ctx.world.f_46443_) {
            return;
        }
        int amount = data.getOrDefault(MapField.COUNT, 1.0).intValue();
        for (int i = 0; i < amount; ++i) {
            Optional type = EntityType.m_20632_((String)data.get(MapField.SUMMONED_PET_ID));
            TamableAnimal en = (TamableAnimal)((EntityType)type.get()).m_20615_(ctx.world);
            en.m_6518_((ServerLevelAccessor)((ServerLevel)ctx.world), ctx.world.m_6436_(ctx.getBlockPos()), MobSpawnType.MOB_SUMMONED, null, null);
            en.m_21828_((Player)ctx.caster);
            BlockPos pos = ctx.caster.m_20183_();
            en.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            int duration = data.get(MapField.LIFESPAN_TICKS).intValue();
            duration = (int)((float)duration * ctx.calculatedSpellData.data.getNumber((String)EventData.DURATION_MULTI, (float)1.0f).number);
            int aggroRadius = data.get(MapField.LIFESPAN_TICKS).intValue();
            aggroRadius = (int)((float)aggroRadius * ctx.calculatedSpellData.data.getNumber((String)EventData.AGGRO_RADIUS, (float)1.0f).number);
            Load.Unit((Entity)en).summonedPetData.setup(ctx.calculatedSpellData.getSpell(), duration, aggroRadius);
            Load.Unit((Entity)en).SetMobLevelAtSpawn((Player)ctx.caster);
            Load.Unit((Entity)en).setLevel(Load.Unit((Entity)ctx.caster).getLevel());
            Load.Unit((Entity)en).setRarity("summon");
            ctx.world.m_7967_((Entity)en);
            boolean counts = data.getOrDefault(MapField.COUNTS_TOWARDS_MAX_SUMMONS, true);
            SummonType summonType = data.getSummonType();
            if (!counts) continue;
            int maxTotal = (int)ctx.calculatedSpellData.data.getNumber((String)EventData.BONUS_TOTAL_SUMMONS, (float)0.0f).number;
            SummonPetAction.despawnIfExceededMaximumSummons(ctx.caster, maxTotal);
        }
    }

    public static void despawnIfExceededMaximumSummons(LivingEntity caster, int max) {
        int current = 0;
        ArrayList<SummonEntity> list = new ArrayList<SummonEntity>();
        for (SummonEntity en : EntityFinder.start((Entity)caster, SummonEntity.class, caster.m_20183_()).searchFor(AllyOrEnemy.all).radius(100.0).build()) {
            if (en.m_269323_() != caster) continue;
            ++current;
            list.add(en);
        }
        list.sort(Comparator.comparingInt(x -> -x.f_19797_));
        int excess = current - max;
        if (excess > 0) {
            for (int i = 0; i < excess; ++i) {
                ((SummonEntity)((Object)list.get(i))).m_146870_();
            }
        }
    }

    public MapHolder create(EntityType type, int lifespan, int amount, SummonType st, boolean counts) {
        MapHolder c = new MapHolder();
        c.put(MapField.SUMMON_TYPE, st.name());
        c.put(MapField.SUMMONED_PET_ID, EntityType.m_20613_((EntityType)type).toString());
        c.put(MapField.ENTITY_NAME, Spell.DEFAULT_EN_NAME);
        c.put(MapField.LIFESPAN_TICKS, Double.valueOf(lifespan));
        c.put(MapField.COUNT, Double.valueOf(amount));
        c.put(MapField.COUNTS_TOWARDS_MAX_SUMMONS, counts);
        c.type = this.GUID();
        return c;
    }

    public String GUID() {
        return "summon_pet";
    }
}

