/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.aoe_data.database.stats.base.EffectCtx;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EventBuilder;
import com.robertx22.mine_and_slash.uncommon.effectdatas.ExilePotionEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.GiveOrTake2;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ExileEffectAction
extends SpellAction {
    public ExileEffectAction() {
        super(Arrays.asList(MapField.EXILE_POTION_ID, MapField.COUNT, MapField.POTION_ACTION, MapField.POTION_DURATION));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        try {
            ExileEffect potion = data.getExileEffect();
            GiveOrTake action = data.getPotionAction();
            int count = data.get(MapField.COUNT).intValue();
            int duration = data.get(MapField.POTION_DURATION).intValue();
            float chance = data.getOrDefault(MapField.CHANCE, 100.0).floatValue();
            targets.forEach(t -> {
                if (RandomUtils.roll((float)chance)) {
                    ExilePotionEvent potionEvent = EventBuilder.ofEffect(ctx.calculatedSpellData, ctx.caster, t, Load.Unit((Entity)ctx.caster).getLevel(), potion, action.getOther(), duration).setSpell(ctx.calculatedSpellData.getSpell()).set(x -> {
                        x.data.getNumber((String)EventData.STACKS).number = count;
                    }).build();
                    potionEvent.spellid = ctx.calculatedSpellData.getSpell().GUID();
                    potionEvent.Activate();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MapHolder giveSeconds(EffectCtx ctx, int seconds) {
        MapHolder dmg = new MapHolder();
        dmg.type = this.GUID();
        dmg.put(MapField.COUNT, 1.0);
        dmg.put(MapField.POTION_DURATION, (double)seconds * 20.0);
        dmg.put(MapField.POTION_ACTION, GiveOrTake.GIVE_STACKS.name());
        dmg.put(MapField.EXILE_POTION_ID, ctx.resourcePath);
        return dmg;
    }

    public MapHolder create(String id, GiveOrTake action, Double duration) {
        MapHolder dmg = new MapHolder();
        dmg.type = this.GUID();
        dmg.put(MapField.COUNT, 1.0);
        dmg.put(MapField.POTION_DURATION, duration);
        dmg.put(MapField.POTION_ACTION, action.name());
        dmg.put(MapField.EXILE_POTION_ID, id);
        return dmg;
    }

    public String GUID() {
        return "exile_effect";
    }

    public static enum GiveOrTake {
        GIVE_STACKS(GiveOrTake2.give),
        REMOVE_STACKS(GiveOrTake2.take),
        REMOVE_NEGATIVE(null);

        private GiveOrTake2 other;

        private GiveOrTake(GiveOrTake2 other) {
            this.other = other;
        }

        GiveOrTake2 getOther() {
            return this.other;
        }
    }
}

