/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components;

import com.robertx22.mine_and_slash.database.data.spells.components.EntityActivation;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.EffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.BaseTargetSelector;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.TargetSelector;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.LivingEntity;

public class ComponentPart {
    public List<MapHolder> targets = new ArrayList<MapHolder>();
    public List<MapHolder> acts = new ArrayList<MapHolder>();
    public List<MapHolder> ifs = new ArrayList<MapHolder>();
    public List<MapHolder> en_preds = new ArrayList<MapHolder>();
    List<ComponentPart> per_entity_hit = null;

    public ComponentPart addPerEntityHit(ComponentPart add) {
        if (this.per_entity_hit == null) {
            this.per_entity_hit = new ArrayList<ComponentPart>();
        }
        this.per_entity_hit.add(add);
        return this;
    }

    public ComponentPart enemiesInRadius(Double radius) {
        this.targets.add(TargetSelector.AOE.enemiesInRadius(radius));
        return this;
    }

    public ComponentPart noKnock() {
        for (MapHolder act : this.acts) {
            if (!act.type.equals(SpellAction.DEAL_DAMAGE.GUID())) continue;
            act.put(MapField.DISABLE_KNOCKBACK, true);
        }
        return this;
    }

    public ComponentPart alliesInRadius(Double radius) {
        this.targets.add(TargetSelector.AOE.alliesInRadius(radius));
        return this;
    }

    public ComponentPart tick(Double ticks) {
        this.ifs.add(EffectCondition.EVERY_X_TICKS.create(ticks));
        return this;
    }

    public ComponentPart setTarget(MapHolder target) {
        this.targets.add(target);
        return this;
    }

    public ComponentPart addActivationRequirement(EntityActivation act) {
        if (act == EntityActivation.ON_EXPIRE) {
            this.addCondition(EffectCondition.ON_ENTITY_EXPIRE.create());
        } else if (act == EntityActivation.ON_HIT) {
            this.addCondition(EffectCondition.ON_HIT.create());
        } else if (act == EntityActivation.ON_CAST) {
            this.addCondition(EffectCondition.ON_CAST.create());
        } else if (act == EntityActivation.ENTITY_BASIC_ATTACKED) {
            this.addCondition(EffectCondition.ON_ATTACKED.create());
        } else {
            throw new NullPointerException("Activation not found");
        }
        return this;
    }

    public void validate() {
        for (MapHolder part : this.ifs) {
            EffectCondition condition = EffectCondition.MAP.get(part.type);
            condition.validate(part);
        }
        for (MapHolder part : this.targets) {
            BaseTargetSelector selector = BaseTargetSelector.MAP.get(part.type);
            selector.validate(part);
        }
        for (MapHolder part : this.acts) {
            SpellAction action = SpellAction.MAP.get(part.type);
            action.validate(part);
        }
        if (this.per_entity_hit != null) {
            this.per_entity_hit.forEach(x -> x.validate());
        }
    }

    public void tryActivate(SpellCtx ctx) {
        if (ctx.world.f_46443_) {
            return;
        }
        for (MapHolder part : this.ifs) {
            EffectCondition condition = EffectCondition.MAP.get(part.type);
            if (condition.canActivate(ctx, part)) continue;
            return;
        }
        HashSet<LivingEntity> list = new HashSet<LivingEntity>();
        for (MapHolder part : this.targets) {
            BaseTargetSelector selector = BaseTargetSelector.MAP.get(part.type);
            List<Object> selected = selector.get(ctx, ctx.caster, ctx.target, ctx.getPos(), part);
            for (MapHolder entityPredicate : this.en_preds) {
                EffectCondition pred = EffectCondition.MAP.get(entityPredicate.type);
                if (pred == null) continue;
                selected = selected.stream().filter(targetEntity -> {
                    SpellCtx chainedCtx = SpellCtx.onEntityHit(ctx, targetEntity);
                    return pred.canActivate(chainedCtx, entityPredicate);
                }).collect(Collectors.toList());
            }
            list.addAll(selected);
        }
        for (MapHolder part : this.acts) {
            SpellAction action = SpellAction.MAP.get(part.type);
            if (action == null) {
                System.out.print(part.type + " action is null");
                continue;
            }
            action.tryActivate(list, ctx, part);
        }
        if (this.per_entity_hit != null) {
            for (LivingEntity en : list) {
                SpellCtx chainedCtx = SpellCtx.onEntityHit(ctx, en);
                for (ComponentPart onEn : this.per_entity_hit) {
                    List<LivingEntity> single = Arrays.asList(en);
                    for (MapHolder part : onEn.ifs) {
                        EffectCondition condition = EffectCondition.MAP.get(part.type);
                        if (condition.canActivate(chainedCtx, part)) continue;
                        return;
                    }
                    for (MapHolder part : onEn.acts) {
                        SpellAction action = SpellAction.MAP.get(part.type);
                        action.tryActivate(single, chainedCtx, part);
                    }
                }
            }
        }
    }

    public ComponentPart addTarget(MapHolder map) {
        this.targets.add(map);
        return this;
    }

    public ComponentPart addActions(MapHolder map) {
        this.acts.add(map);
        return this;
    }

    public ComponentPart addCondition(MapHolder map) {
        this.ifs.add(map);
        return this;
    }

    public ComponentPart addEntityPredicate(MapHolder map) {
        this.en_preds.add(map);
        return this;
    }
}

