/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spell_school;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SpellSchool
implements JsonExileRegistry<SpellSchool>,
IAutoGson<SpellSchool>,
IAutoLocName {
    public static SpellSchool SERIALIZER = new SpellSchool();
    public String id = "";
    public transient String locname = "";
    public static int MAX_Y_ROWS = 7;
    public static int MAX_X_ROWS = 10;
    public HashMap<String, PointData> perks = new HashMap();
    public List<Integer> lvl_reqs = Arrays.asList(1, 5, 10, 15, 20, 25, 30);

    public int getLevelNeededToAllocate(PointData point) {
        int req = this.lvl_reqs.get(point.y);
        return req;
    }

    public boolean isLevelEnoughFor(LivingEntity en, Perk perk) {
        return Load.Unit((Entity)en).getLevel() >= this.getLevelNeededToAllocate(this.perks.get(perk.GUID()));
    }

    public ResourceLocation getIconLoc() {
        return SlashRef.guiId("asc_classes/class/" + this.id);
    }

    public ResourceLocation getBackgroundLoc() {
        return SlashRef.guiId("asc_classes/background/" + this.id);
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.SPELL_SCHOOL;
    }

    public Class<SpellSchool> getClassForSerialization() {
        return SpellSchool.class;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return 1000;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Spells;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.asc_class." + this.id;
    }

    @Override
    public String locNameForLangFile() {
        return this.locname;
    }
}

