/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.requirements;

import com.robertx22.mine_and_slash.database.data.requirements.bases.BaseRequirement;
import com.robertx22.mine_and_slash.database.data.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.tags.TagList;
import com.robertx22.mine_and_slash.tags.TagType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;

public class TagRequirement
extends BaseRequirement<TagRequirement> {
    public TagType type = TagType.GearSlot;
    public List<String> included = new ArrayList<String>();
    public List<String> excluded = new ArrayList<String>();
    public ReqType req_type = ReqType.INCLUDES_ANY;

    public TagRequirement(TagType type, List<String> included, List<String> excluded) {
        this.type = type;
        this.included = included;
        this.excluded = excluded;
    }

    private TagRequirement() {
    }

    @Override
    public boolean meetsRequierment(GearRequestedFor requested) {
        TagList list = requested.forSlot.getTags();
        if (this.excluded.stream().anyMatch(y -> list.contains((String)y))) {
            return false;
        }
        if (this.req_type == ReqType.HAS_ALL) {
            return this.included.stream().allMatch(x -> list.contains((String)x));
        }
        return this.included.stream().anyMatch(x -> list.contains((String)x));
    }

    @Override
    public List<MutableComponent> GetTooltipString() {
        return new ArrayList<MutableComponent>();
    }

    public static enum ReqType {
        INCLUDES_ANY,
        HAS_ALL;

    }
}

