/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.rarities;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import net.minecraft.ChatFormatting;

public final class MobRarity
implements JsonExileRegistry<MobRarity>,
IAutoGson<MobRarity>,
IAutoLocName {
    public static MobRarity SERIALIZER = new MobRarity();
    public String text_format;
    String name = "";
    public String id = "";
    public int weight = 1000;
    public int min_lvl;
    public int force_custom_hp = -1;
    public float dmg_multi;
    public float extra_hp_multi;
    public float stat_multi;
    public float loot_multi;
    public float exp_multi;
    public int affixes = 0;

    public static MobRarity of(String id, String name, int weight, int minlvl, float bonusstatmulti, int affixes, ChatFormatting color, boolean summon) {
        float lootmulti = 1.0f + bonusstatmulti * 0.5f;
        MobRarity r = new MobRarity();
        r.text_format = color.name();
        r.id = id;
        r.name = name;
        r.weight = weight;
        r.min_lvl = minlvl;
        r.stat_multi = 1.0f + bonusstatmulti * 1.0f;
        r.extra_hp_multi = 1.0f + bonusstatmulti * 1.0f;
        r.dmg_multi = 1.0f + bonusstatmulti * 0.25f;
        r.loot_multi = lootmulti;
        r.exp_multi = lootmulti;
        r.affixes = affixes;
        if (summon) {
            r.stat_multi = 1.0f;
            r.extra_hp_multi = 1.0f;
            r.dmg_multi = 1.0f;
        }
        r.addToSerializables();
        return r;
    }

    public MobRarity setForceCustomHP(int hp) {
        this.force_custom_hp = hp;
        return this;
    }

    public boolean forcesCustomHp() {
        return this.force_custom_hp > 0;
    }

    public ChatFormatting textFormatting() {
        try {
            return ChatFormatting.valueOf((String)this.text_format);
        }
        catch (Exception exception) {
            return ChatFormatting.GRAY;
        }
    }

    public int minMobLevelForRandomSpawns() {
        return this.min_lvl;
    }

    public float DamageMultiplier() {
        return this.dmg_multi;
    }

    public float ExtraHealthMulti() {
        return this.extra_hp_multi;
    }

    public float StatMultiplier() {
        return this.stat_multi;
    }

    public float LootMultiplier() {
        return this.loot_multi;
    }

    public float expMulti() {
        return this.exp_multi;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.MOB_RARITY;
    }

    public Class<MobRarity> getClassForSerialization() {
        return MobRarity.class;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return this.weight;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Rarities;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.mob_rarity." + this.GUID();
    }

    @Override
    public String locNameForLangFile() {
        return this.name;
    }
}

