/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.prophecy;

import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyStart;
import com.robertx22.mine_and_slash.database.data.prophecy.starts.GearProphecy;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.RarityItemBlueprint;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ProphecyModifierType {
    GEAR_TYPE{

        @Override
        public MutableComponent getTooltip(String data) {
            return ((BaseGearType)ExileDB.GearTypes().get(data)).locName().m_130940_(ChatFormatting.WHITE);
        }

        @Override
        public float chanceToSpawn() {
            return 15.0f;
        }

        @Override
        public void set(ItemBlueprint b, String data) {
            if (b instanceof GearBlueprint) {
                GearBlueprint gb = (GearBlueprint)b;
                gb.gearItemSlot.set(data);
            }
        }

        @Override
        public boolean canApplyTo(ProphecyStart start, ItemBlueprint b) {
            return start instanceof GearProphecy;
        }
    }
    ,
    GEAR_RARITY{

        @Override
        public MutableComponent getTooltip(String data) {
            GearRarity rar = (GearRarity)ExileDB.GearRarities().get(data);
            return rar.locName().m_130940_(rar.textFormatting());
        }

        @Override
        public float chanceToSpawn() {
            return 75.0f;
        }

        @Override
        public void set(ItemBlueprint b, String data) {
            if (b instanceof RarityItemBlueprint) {
                RarityItemBlueprint gb = (RarityItemBlueprint)b;
                gb.rarity.set((GearRarity)ExileDB.GearRarities().get(data));
            }
        }

        @Override
        public boolean canApplyTo(ProphecyStart start, ItemBlueprint b) {
            return b instanceof RarityItemBlueprint;
        }
    };


    public abstract MutableComponent getTooltip(String var1);

    public abstract float chanceToSpawn();

    public abstract void set(ItemBlueprint var1, String var2);

    public abstract boolean canApplyTo(ProphecyStart var1, ItemBlueprint var2);
}

