/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.profession.all;

import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.profession.ExpSources;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.data.profession.all.ProfessionMatItems;
import com.robertx22.mine_and_slash.mmorpg.registers.deferred_wrapper.RegObj;
import com.robertx22.mine_and_slash.tags.all.SlotTags;
import com.robertx22.mine_and_slash.tags.imp.SlotTag;
import com.robertx22.temp.SkillItemTier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class Professions {
    public static String FARMING = "farming";
    public static String MINING = "mining";
    public static String HUSBANDRY = "husbandry";
    public static String FISHING = "fishing";
    public static String COOKING = "cooking";
    public static String ALCHEMY = "alchemy";
    public static String INFUSING = "enchanting";
    public static String GEAR_CRAFTING = "gear_crafting";
    public static String SALVAGING = "salvaging";
    public static List<String> STATION_PROFESSIONS = Arrays.asList(COOKING, SALVAGING, ALCHEMY, GEAR_CRAFTING, INFUSING);
    public static List<String> TOOL_PROFESSIONS = Arrays.asList(FARMING, MINING, HUSBANDRY, FISHING);
    public static List<String> DROP_PROFESSIONS = Arrays.asList(FARMING, MINING, HUSBANDRY, SALVAGING, FISHING);
    public static List<String> ALL = Arrays.asList(FARMING, MINING, FISHING, SALVAGING, HUSBANDRY, COOKING, ALCHEMY, INFUSING);

    public static void init() {
        Builder.of(SALVAGING, "Salvaging", "Salvaging is the process of turning junk loot into useful materials in the Salvaging Station. You can only salvage Gear with Mine and Slash souls and other Mine and Slash rarity items.").build();
        int FARM_EXP = 30;
        int ORE_EXP = 100;
        Builder.of(FARMING, "Farming", "Farming gives you a chance to obtain extra custom materials by chopping wheat, potatoes and so on. You can see what gives experience in the Mine and Slash HUB > Library screen.").tool(SlotTags.farming_tool).crop(SkillItemTier.TIER0, FARM_EXP, Items.f_42405_, ExpSources.REQ_GROWTH_STAGE).crop(SkillItemTier.TIER0, FARM_EXP, Items.f_42620_, ExpSources.REQ_GROWTH_STAGE).crop(SkillItemTier.TIER1, FARM_EXP, Items.f_42575_, new String[0]).crop(SkillItemTier.TIER2, 50, Items.f_42732_, ExpSources.REQ_GROWTH_STAGE).crop(SkillItemTier.TIER3, 60, Items.f_42619_, ExpSources.REQ_GROWTH_STAGE).crop(SkillItemTier.TIER4, 75, Items.f_42588_, ExpSources.REQ_GROWTH_STAGE).crop(SkillItemTier.TIER5, 100, Items.f_42533_, ExpSources.REQ_GROWTH_STAGE).dropTiered(ProfessionMatItems.TIERED_MAIN_MATS.get(FARMING), 1.0f).build();
        Builder.of(FISHING, "Fishing", "Fishing gives you a chance to obtain extra custom materials by fishing.").tool(SlotTags.fishing_tool).dropTiered(ProfessionMatItems.TIERED_MAIN_MATS.get(FISHING), 3.0f).build();
        Builder.of(HUSBANDRY, "Animal Breeding", "Animal Breeding gives you a chance to obtain extra custom materials by breeding animals.").tool(SlotTags.husbandry_tool).dropTiered(ProfessionMatItems.TIERED_MAIN_MATS.get(HUSBANDRY), 1.0f).build();
        Builder.of(MINING, "Mining", "Mining gives you chance to obtain extra custom materials by mining ores. You can see which ores give experience in the Mine and Slash HUB > Library screen.").tool(SlotTags.mining_tool).blockTag(SkillItemTier.TIER0, 15, BlockTags.f_144262_).blockTag(SkillItemTier.TIER1, 20, BlockTags.f_144264_).blockTag(SkillItemTier.TIER1, 15, BlockTags.f_144260_).blockTag(SkillItemTier.TIER1, 25, BlockTags.f_144261_).blockTag(SkillItemTier.TIER2, 50, BlockTags.f_144258_).blockTag(SkillItemTier.TIER3, 75, BlockTags.f_13043_).blockTag(SkillItemTier.TIER4, 100, BlockTags.f_144263_).blockTag(SkillItemTier.TIER5, 200, BlockTags.f_144259_).dropTiered(ProfessionMatItems.TIERED_MAIN_MATS.get(MINING), 1.0f).build();
        Builder.of(COOKING, "Cooking", "Cooking is a crafting profession that turns materials from gathering professions into foods that can provide stat buffs.").build();
        Builder.of(ALCHEMY, "Alchemy", "Alchemy is a crafting profession that turns materials from gathering professions into Potions.").build();
        Builder.of(INFUSING, "Infusing", "Infusing is a crafting profession that turns materials from gathering professions into scrolls that can infuse extra power into your gear.").build();
        Builder.of(GEAR_CRAFTING, "Gear Crafting", "Gear Crafting is a crafting profession that turns materials from gathering professions into new pieces of gear.").build();
    }

    private static class Builder {
        Profession p = new Profession();

        private Builder() {
        }

        public static Builder of(String id, String locname, String desc) {
            Builder b = new Builder();
            b.p.id = id;
            b.p.desc = desc;
            b.p.locname = locname;
            return b;
        }

        public Builder tool(SlotTag tag) {
            this.p.tool_tag = tag.GUID();
            return this;
        }

        public Builder crop(SkillItemTier tier, int exp, Item item, String ... tags) {
            this.p.exp_sources.add(tier, ExpSources.Type.FARM_ITEM, VanillaUTIL.REGISTRY.items().getKey((Object)item).toString(), exp, tags);
            return this;
        }

        public Builder item(SkillItemTier tier, int exp, Item ... items) {
            for (Item block : items) {
                this.p.exp_sources.add(tier, ExpSources.Type.FARM_ITEM, VanillaUTIL.REGISTRY.items().getKey((Object)block).toString(), exp, new String[0]);
            }
            return this;
        }

        public Builder block(SkillItemTier tier, int exp, Block ... blocks) {
            for (Block block : blocks) {
                this.p.exp_sources.add(tier, ExpSources.Type.BLOCK, VanillaUTIL.REGISTRY.blocks().getKey((Object)block).toString(), exp, new String[0]);
            }
            return this;
        }

        public Builder blockTag(SkillItemTier tier, int exp, TagKey<Block> ... blocks) {
            for (TagKey<Block> block : blocks) {
                this.p.exp_sources.add(tier, ExpSources.Type.BLOCK_TAG, block.f_203868_().toString(), exp, new String[0]);
            }
            return this;
        }

        public Builder dropTiered(HashMap<SkillItemTier, RegObj<Item>> map, float chancemulti) {
            for (Map.Entry<SkillItemTier, RegObj<Item>> en : map.entrySet()) {
                Item item = en.getValue().get();
                String id = VanillaUTIL.REGISTRY.items().getKey((Object)item).toString();
                Profession.ProfessionDrop drop = new Profession.ProfessionDrop(id, 1, 1000, en.getKey().lvl_req);
                if (!this.p.tiered_drops.containsKey((Object)en.getKey())) {
                    this.p.tiered_drops.put(en.getKey(), new ArrayList());
                }
                this.p.tiered_drops.get((Object)en.getKey()).add(new Profession.ChancedDrop(Arrays.asList(drop), Profession.DropCategory.MAIN, 10.0f * chancemulti));
            }
            return this;
        }

        public void build() {
            this.p.addToSerializables();
        }
    }
}

