/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.map_affix;

import com.robertx22.mine_and_slash.aoe_data.database.exile_effects.adders.ModEffects;
import com.robertx22.mine_and_slash.aoe_data.database.stats.DefenseStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.EffectStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.OffenseStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.base.EffectCtx;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.map_affix.MapAffix;
import com.robertx22.mine_and_slash.database.data.stats.effects.defense.MaxElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.DodgeRating;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.BonusPhysicalAsElemental;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.Energy;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.EnergyRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.Health;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.HealthRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShield;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShieldRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.Mana;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.ManaRegen;
import com.robertx22.mine_and_slash.tags.all.MapAffixTags;
import com.robertx22.mine_and_slash.tags.imp.MapAffixTag;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import java.util.List;
import java.util.stream.Collectors;

public class MapAffixes {
    public static String crit = "crit";

    public static void init() {
        MapAffixes.prophecyAffixes();
        List elements = Elements.getAllSingle().stream().filter(x -> x != Elements.Physical).collect(Collectors.toList());
        for (EffectCtx curse : ModEffects.getCurses()) {
            new MapAffix(curse.GUID() + "_curse").addMod(new StatMod(1.0f, 1.0f, EffectStats.CURSE_SELF.get(curse))).affectsPlayer().addToSerializables();
        }
        for (Elements element : elements) {
            new MapAffix(element.guidName + "_atk").addMod(new StatMod(25.0f, 100.0f, new BonusPhysicalAsElemental(element))).upsMapResistRequirement(element, 25).addToSerializables();
            new MapAffix(element.guidName + "_res").addMod(new StatMod(20.0f, 60.0f, new ElementalResist(element))).addToSerializables();
            new MapAffix(element.guidName + "_minus_res").addMod(new StatMod(-15.0f, -30.0f, new ElementalResist(element))).affectsPlayer().addToSerializables();
        }
        new MapAffix(crit).addMod(new StatMod(25.0f, 100.0f, OffenseStats.CRIT_CHANCE.get())).addToSerializables();
        new MapAffix("crit_dmg").addMod(new StatMod(20.0f, 50.0f, OffenseStats.CRIT_DAMAGE.get())).addToSerializables();
        MapAffix allres = new MapAffix("all_ele_res");
        for (Elements ele : Elements.getAllSingle()) {
            allres.addMod(new StatMod(20.0f, 50.0f, new ElementalResist(ele), ModType.FLAT));
        }
        allres.addToSerializables();
        new MapAffix("health").addMod(new StatMod(20.0f, 50.0f, Health.getInstance(), ModType.MORE)).addToSerializables();
        new MapAffix("armor").addMod(new StatMod(20.0f, 100.0f, Armor.getInstance(), ModType.MORE)).addToSerializables();
        new MapAffix("minus_ene_reg").addMod(new StatMod(-20.0f, -75.0f, ManaRegen.getInstance(), ModType.MORE)).affectsPlayer().addToSerializables();
        new MapAffix("minus_mana_reg").addMod(new StatMod(-20.0f, -75.0f, EnergyRegen.getInstance(), ModType.MORE)).affectsPlayer().addToSerializables();
        new MapAffix("minus_hp_reg").addMod(new StatMod(-20.0f, -75.0f, HealthRegen.getInstance(), ModType.MORE)).affectsPlayer().addToSerializables();
        new MapAffix("minus_ms_reg").addMod(new StatMod(-20.0f, -75.0f, MagicShieldRegen.getInstance(), ModType.MORE)).affectsPlayer().addToSerializables();
    }

    private static void prophecyAffixes() {
        List<Elements> elements = Elements.getAllSingle();
        for (EffectCtx curse : ModEffects.getCurses()) {
            MapAffixes.prophecyAffix("prophecy_" + curse.GUID(), MapAffixTags.CURSE).addMod(new StatMod(1.0f, 1.0f, EffectStats.CURSE_SELF.get(curse)));
        }
        for (Elements element : elements) {
            MapAffixes.prophecyAffix("prophecy_max_ele_res" + element.guidName, MapAffixTags.DMG_TAKEN).addMod(new MaxElementalResist(element).mod(-5.0f, -5.0f)).addMod(new ElementalResist(element).mod(-25.0f, -25.0f));
            MapAffixes.prophecyAffix("prophecy_ele_dmg" + element.guidName, MapAffixTags.DMG_DEALT).addMod(OffenseStats.ELEMENTAL_DAMAGE.get(element).mod(-50.0f, -50.0f));
            MapAffixes.prophecyAffix("prophecy_always_crit" + element.guidName, MapAffixTags.DMG_TAKEN).addMod(DefenseStats.ALWAYS_CRIT_WHEN_HIT_BY_ELEMENT.get(element).mod(1.0f, 1.0f));
        }
        MapAffixes.prophecyAffix("prophecy_hp", MapAffixTags.DMG_TAKEN).addMod(Health.getInstance().mod(-25.0f, -25.0f).percent());
        MapAffixes.prophecyAffix("prophecy_mana", MapAffixTags.LESS_RESOURCE).addMod(Mana.getInstance().mod(-25.0f, -25.0f).percent());
        MapAffixes.prophecyAffix("prophecy_ene", MapAffixTags.LESS_RESOURCE).addMod(Energy.getInstance().mod(-25.0f, -25.0f).percent());
        MapAffixes.prophecyAffix("prophecy_ms", MapAffixTags.DMG_TAKEN).addMod(MagicShield.getInstance().mod(-25.0f, -25.0f).percent());
        MapAffixes.prophecyAffix("prophecy_armor", MapAffixTags.DMG_TAKEN).addMod(Armor.getInstance().mod(-25.0f, -25.0f).percent());
        MapAffixes.prophecyAffix("prophecy_dodge", MapAffixTags.DMG_TAKEN).addMod(DodgeRating.getInstance().mod(-25.0f, -25.0f).percent());
        MapAffixes.prophecyAffix("prophecy_total_dmg", MapAffixTags.DMG_DEALT).addMod(OffenseStats.TOTAL_DAMAGE.get().mod(-10.0f, -10.0f).more());
        MapAffixes.prophecyAffix("prophecy_crit", MapAffixTags.LESS_CRIT).addMod(OffenseStats.CRIT_CHANCE.get().mod(-25.0f, -25.0f).more());
        MapAffixes.prophecyAffix("prophecy_crit_dmg", MapAffixTags.LESS_CRIT).addMod(OffenseStats.CRIT_DAMAGE.get().mod(-25.0f, -25.0f).more());
    }

    static MapAffix prophecyAffix(String id, MapAffixTag tag) {
        MapAffix m = new MapAffix(id).setProphecyLeague().affectsPlayer();
        m.prophecy_type = tag.GUID();
        m.addToSerializables();
        return m;
    }
}

