/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.loot_chest.base;

import com.google.common.collect.ImmutableList;
import com.robertx22.library_of_exile.utils.ItemstackDataSaver;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.loot_chest.base.LootChest;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AdditionalBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.NameBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.SalvageBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.usableitemblocks.UsageBlock;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.ChestContent;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LootChestData
implements ICommonDataItem<GearRarity> {
    public int num = 1;
    public String rar = "";
    public int lvl = 1;
    public String id = "";
    public String key = "";

    public LootChest getLootChest() {
        return (LootChest)ExileDB.LootChests().get(this.id);
    }

    @Override
    public String getRarityId() {
        return null;
    }

    @Override
    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    public Item getDataKey() {
        if (this.key.isEmpty()) {
            return null;
        }
        return (Item)VanillaUTIL.REGISTRY.items().get(new ResourceLocation(this.key));
    }

    public boolean isLocked() {
        return this.getLootChest().getKey() != null || this.getDataKey() != null;
    }

    public Item getKeyItem() {
        if (this.getDataKey() != null) {
            return this.getDataKey();
        }
        return this.getLootChest().getKey();
    }

    public boolean canOpen(Player p) {
        if (!this.isLocked()) {
            return true;
        }
        return p.m_150109_().m_18947_(this.getKeyItem()) > 0;
    }

    public void spendKey(Player p) {
        for (int i = 0; i < p.m_150109_().m_6643_(); ++i) {
            ItemStack stack = p.m_150109_().m_8020_(i);
            if (!stack.m_150930_(this.getKeyItem())) continue;
            stack.m_41774_(1);
            return;
        }
    }

    @Override
    public void BuildTooltip(TooltipContext ctx) {
        List<Component> tip = ctx.tooltip;
        tip.clear();
        tip.addAll(new ExileTooltips().accept(new NameBlock(Collections.singletonList(ctx.stack.m_41786_()))).accept(new RarityBlock(this.getRarity())).accept(new UsageBlock((List<? extends Component>)ImmutableList.of((Object)Itemtips.CHEST_CONTAINS.locName(new ChestContent(this.getLootChest().GUID()).get().locName().m_130940_(ChatFormatting.YELLOW)), (Object)TooltipUtils.level(this.lvl)))).accept(new AdditionalBlock((List<? extends Component>)ImmutableList.of((Object)Chats.OPEN_LOOT_CHEST.locName().m_130940_(ChatFormatting.AQUA)))).accept(new AdditionalBlock(() -> {
            if (this.getKeyItem() != null) {
                return ImmutableList.of((Object)Itemtips.NEED_KEY.locName(this.getKeyItem().m_7968_().m_41786_()).m_130940_(ChatFormatting.GOLD));
            }
            return Collections.EMPTY_LIST;
        }).showWhen(this::isLocked)).accept(new SalvageBlock(this)).release());
    }

    @Override
    public ItemstackDataSaver<LootChestData> getStackSaver() {
        return StackSaving.LOOT_CHEST;
    }

    @Override
    public void saveToStack(ItemStack stack) {
        this.getStackSaver().saveTo(stack, (Object)this);
    }

    @Override
    public List<ItemStack> getSalvageResult(ItemStack stack) {
        return Arrays.asList(new ItemStack[0]);
    }

    @Override
    public boolean isSalvagable() {
        return false;
    }

    @Override
    public int getLevel() {
        return this.lvl;
    }

    @Override
    public ToggleAutoSalvageRarity.SalvageType getSalvageType() {
        return ToggleAutoSalvageRarity.SalvageType.GEAR;
    }
}

