/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.league;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.utils.TeleportUtils;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanic;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanics;
import com.robertx22.mine_and_slash.database.data.league.LeaguePiecesList;
import com.robertx22.mine_and_slash.database.data.league.LeagueStructurePieces;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.mmorpg.ModErrors;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class LeagueStructure {
    public static LeagueStructure EMPTY = new LeagueStructure(LeagueMechanics.NONE){

        @Override
        public BlockPos getTeleportPos(BlockPos pos) {
            return pos;
        }

        @Override
        public LeaguePiecesList getPieces(MapItemData map) {
            return new LeaguePiecesList(Arrays.asList(new LeagueStructurePieces[0]));
        }

        @Override
        public int startY() {
            return 0;
        }

        @Override
        public boolean isInsideLeague(ServerLevel level, BlockPos pos) {
            MapData md = Load.mapAt((Level)level, pos);
            MapItemData map = md.map;
            return ExileDB.LeagueMechanics().getList().stream().filter(x -> !x.getStructure((MapItemData)map).getPieces((MapItemData)map).list.isEmpty()).allMatch(x -> !x.getStructure(map).isInsideLeague(level, pos));
        }
    };
    public LeagueMechanic league;

    public LeagueStructure(LeagueMechanic league) {
        this.league = league;
    }

    public static LeagueMechanic getMechanicFromPosition(ServerLevel sw, BlockPos pos) {
        MapData md = Load.mapAt((Level)sw, pos);
        MapItemData map = md.map;
        List list = ExileDB.LeagueMechanics().getFilterWrapped((Predicate<LeagueMechanic>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getMechanicFromPosition$0(com.robertx22.mine_and_slash.maps.MapItemData net.minecraft.server.level.ServerLevel net.minecraft.core.BlockPos com.robertx22.mine_and_slash.database.data.league.LeagueMechanic ), (Lcom/robertx22/mine_and_slash/database/data/league/LeagueMechanic;)Z)((MapItemData)map, (ServerLevel)sw, (BlockPos)pos)).list;
        if (!list.isEmpty()) {
            return (LeagueMechanic)list.get(0);
        }
        return LeagueMechanics.NONE;
    }

    public abstract BlockPos getTeleportPos(BlockPos var1);

    public abstract LeaguePiecesList getPieces(MapItemData var1);

    public abstract int startY();

    public abstract boolean isInsideLeague(ServerLevel var1, BlockPos var2);

    public final void tryGenerate(ServerLevel level, ChunkPos pos, Random ran) {
        try {
            String s;
            LeagueStructurePieces pieces;
            ResourceLocation room;
            MapData md = Load.mapAt((Level)level, pos.m_151384_(0, 0, 0));
            if (md == null || md.map == null) {
                return;
            }
            MapItemData map = md.map;
            LeaguePiecesList list = this.getPieces(map);
            if (!this.getPieces((MapItemData)map).list.isEmpty() && (room = (pieces = list.get(s = md.leagues.get((LeagueMechanic)this.league).map.get(this.league.getStructureId()))).getRoomForChunk(pos)) != null) {
                this.generateStructure(map, (LevelAccessor)level, room, pos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean generateStructure(MapItemData map, LevelAccessor world, ResourceLocation room, ChunkPos cpos) {
        try {
            Optional opt;
            if (!this.getPieces((MapItemData)map).list.isEmpty() && (opt = world.m_7654_().m_236738_().m_230407_(room)).isPresent()) {
                StructureTemplate template = (StructureTemplate)opt.get();
                StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74392_(false);
                settings.m_74381_(settings.m_74409_());
                BlockPos position = cpos.m_151384_(0, this.startY(), 0);
                if (template == null) {
                    ExileLog.get().warn("FATAL ERROR: Structure does not exist (" + room.toString() + ")", new Object[0]);
                    return false;
                }
                settings.m_74379_(Rotation.NONE);
                template.m_230328_((ServerLevelAccessor)world, position, position, settings, world.m_213780_(), 2);
            }
        }
        catch (Exception e) {
            ModErrors.print(e);
            return false;
        }
        return true;
    }

    public final void teleportToStartOfLeague(Player p) {
        MapData map = Load.mapAt(p.m_9236_(), p.m_20183_());
        if (map != null) {
            Long lo = map.leagues.get((LeagueMechanic)this.league).spawn_pos;
            BlockPos tp = BlockPos.m_122022_((long)lo);
            if (lo != 0L) {
                Load.player((Player)p).map.tp_back_from_league_pos = p.m_20183_().m_121878_();
                TeleportUtils.teleport((ServerPlayer)((ServerPlayer)p), (BlockPos)tp);
            }
        }
    }

    public final void teleportBackToDungeon(Player p) {
        Load.player((Player)p).map.teleportBackFromLeagueToDungeon(p);
    }

    private static /* synthetic */ boolean lambda$getMechanicFromPosition$0(MapItemData map, ServerLevel sw, BlockPos pos, LeagueMechanic x) {
        return x.getStructure(map) != null && x.getStructure(map).isInsideLeague(sw, pos);
    }
}

