/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.league;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanic;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanics;
import com.robertx22.mine_and_slash.database.data.league.LeaguePiecesList;
import com.robertx22.mine_and_slash.database.data.league.LeagueStructure;
import com.robertx22.mine_and_slash.database.data.league.LeagueStructurePieces;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.maps.LeagueData;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.maps.processors.helpers.MobBuilder;
import com.robertx22.mine_and_slash.mechanics.base.LeagueBlockData;
import com.robertx22.mine_and_slash.mechanics.base.LeagueControlBlockEntity;
import com.robertx22.mine_and_slash.mechanics.harvest.HarvestItems;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashBlocks;
import com.robertx22.mine_and_slash.mmorpg.registers.deferred_wrapper.RegObj;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.OnScreenMessageUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class HarvestLeague
extends LeagueMechanic {
    public static MapField<Double> KILLS = new MapField("kills");
    public int ticksLast = 1200;
    int maxKills = 200;
    int maximumBonusLootTimes = 30;

    @Override
    public int getDefaultSpawns() {
        return 1;
    }

    @Override
    public void onMapStartSetup(LeagueData data) {
    }

    @Override
    public Block getTeleportBlock() {
        return SlashBlocks.HARVEST_TELEPORT.get();
    }

    @Override
    public LeagueStructure getStructure(MapItemData map) {
        return new LeagueStructure(this){

            @Override
            public BlockPos getTeleportPos(BlockPos pos) {
                BlockPos p = MapData.getStartChunk(pos).m_151384_(0, 0, 0);
                p = new BlockPos(p.m_123341_() + 10, this.startY() + 5 + 3, p.m_123343_() + 22);
                return p;
            }

            @Override
            public LeaguePiecesList getPieces(MapItemData map) {
                return new LeaguePiecesList(Arrays.asList(new LeagueStructurePieces(2, "harvest/circle")));
            }

            @Override
            public int startY() {
                return 85;
            }

            @Override
            public boolean isInsideLeague(ServerLevel level, BlockPos pos) {
                return pos.m_123342_() >= this.startY() && pos.m_123342_() <= this.startY() + 30;
            }
        };
    }

    @Override
    public float getBaseSpawnChance() {
        return 30.0f;
    }

    @Override
    public void onKillMob(MapData map, LootInfo info) {
        map.leagues.get((LeagueMechanic)this).map.modify(KILLS, 0.0, x -> x + 1.0);
        float lootChance = (float)this.maximumBonusLootTimes * (100.0f / (float)this.maxKills);
        if (RandomUtils.roll((float)lootChance)) {
            for (ItemStack stack : this.generateMobLoot(info)) {
                info.mobKilled.m_5552_(stack, 1.0f);
            }
        }
    }

    private List<ItemStack> generateMobLoot(LootInfo info) {
        Item seeditem = (Item)((RegObj)RandomUtils.randomFromList(Arrays.asList(HarvestItems.BLUE_INGOT, HarvestItems.GREEN_INGOT, HarvestItems.PURPLE_INGOT))).get();
        ItemStack seeds = new ItemStack((ItemLike)seeditem, RandomUtils.RandomRange((int)1, (int)5));
        return Arrays.asList(seeds);
    }

    @Override
    public void spawnMechanicInMap(ServerLevel level, BlockPos pos) {
        level.m_7731_(pos, SlashBlocks.HARVEST_TELEPORT.get().m_49966_(), 2);
    }

    @Override
    public void onTick(MapData map, ServerLevel level, BlockPos pos, LeagueControlBlockEntity be, LeagueBlockData data) {
        int mobs;
        ++data.ticks;
        if (data.ticks > this.ticksLast || map.leagues.get((LeagueMechanic)this).map.getOrDefault(KILLS, 0.0).intValue() > this.maxKills) {
            data.finished = true;
            for (Player p : be.getPlayers()) {
                p.m_213846_((Component)Chats.VINES_SHRINK.locName().m_130940_(ChatFormatting.GREEN));
            }
            return;
        }
        int secleft = (this.ticksLast - data.ticks) / 20;
        int maxsec = this.ticksLast / 20;
        for (Player p : be.getPlayers()) {
            OnScreenMessageUtils.actionBar((ServerPlayer)p, Component.m_237113_((String)(secleft + "/" + maxsec + "s Remaining")).m_130940_(ChatFormatting.RED));
        }
        if (data.ticks % 20 == 0 && (mobs = be.getMobs().size()) < 20) {
            int tospawn = 4;
            for (int i = 0; i < tospawn; ++i) {
                EntityType type = this.getRandomMobToSpawn();
                BlockPos spawnpos = be.getRandomMobSpawnPos(type);
                if (spawnpos == null) continue;
                for (Mob mob : MobBuilder.of(this.getRandomMobToSpawn(), x -> {
                    x.amount = 1;
                }).summonMobs((Level)level, spawnpos)) {
                    if (!RandomUtils.roll((int)25)) continue;
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1200, RandomUtils.RandomRange((int)1, (int)4)));
                }
            }
        }
    }

    @Override
    public ChatFormatting getTextColor() {
        return ChatFormatting.GREEN;
    }

    public EntityType getRandomMobToSpawn() {
        if (RandomUtils.roll((int)10)) {
            return EntityType.f_20554_;
        }
        if (RandomUtils.roll((int)5)) {
            return EntityType.f_20495_;
        }
        if (RandomUtils.roll((int)5)) {
            return EntityType.f_20512_;
        }
        if (RandomUtils.roll((int)2)) {
            return EntityType.f_20481_;
        }
        return EntityType.f_20479_;
    }

    public String GUID() {
        return LeagueMechanics.HARVEST_ID;
    }

    public int Weight() {
        return 1000;
    }

    @Override
    public String locNameForLangFile() {
        return "Harvest League";
    }
}

