/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.game_balance_config;

import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.data.game_balance_config.LevelScalingConfig;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsConfig;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.HashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class GameBalanceConfig
implements JsonExileRegistry<GameBalanceConfig>,
IAutoGson<GameBalanceConfig> {
    public static GameBalanceConfig SERIALIZER = new GameBalanceConfig();
    public String id = "game_balance";
    public static String ID = "game_balance";
    public int MAX_LEVEL = 100;
    public LevelScalingConfig NORMAL_STAT_SCALING = new LevelScalingConfig(1.0f, 0.2f, false);
    public LevelScalingConfig SLOW_STAT_SCALING = new LevelScalingConfig(1.0f, 0.01f, true);
    public LevelScalingConfig MANA_COST_SCALING = new LevelScalingConfig(1.0f, 0.2f, true);
    public LevelScalingConfig CORE_STAT_SCALING = new LevelScalingConfig(1.0f, 0.05f, true);
    public LevelScalingConfig STAT_REQ_SCALING = new LevelScalingConfig(2.0f, 2.0f, true);
    public LevelScalingConfig MOB_DAMAGE_SCALING = new LevelScalingConfig(1.0f, 0.25f, false);
    public HashMap<PlayerPointsType, PlayerPointsConfig> player_points = new HashMap();
    public double MOB_DMG_MULTI_PER_MAP_RES_REQ_LACKING = 0.05;
    public double HP_MOB_BONUS_PER_MAP_TIER = 0.1;
    public double DMG_MOB_BONUS_PER_MAP_TIER = 0.01;
    public double MIN_SPELL_COOLDOWN_MULTI = 0.2;
    public double CRAFTED_GEAR_POTENTIAL_MULTI = 0.5;
    public int MAX_BONUS_SPELL_LEVELS = 5;
    public double MOB_HP_POWER_SCALING = 1.003;
    public double MOB_DMG_POWER_SCALING = 1.003;
    public double MOB_DMG_POWER_SCALING_BASE = 1.0;
    public double MOB_HP_POWER_SCALING_BASE = 1.0;
    public double PROFESSION_EXP_PENALTY_PER_LOWER_LEVEL = 0.02;
    public int link_1_lvl = 1;
    public int link_2_lvl = 5;
    public int link_3_lvl = 10;
    public int link_4_lvl = 25;
    public int link_5_lvl = 50;
    public float DMG_REDUCT_PER_CHAIN = 0.2f;
    public float MIN_CHAIN_DMG = 0.2f;

    public static GameBalanceConfig get() {
        ExileRegistryContainer d = Database.getRegistry((ExileRegistryType)ExileRegistryTypes.GAME_BALANCE);
        if (d.isRegistered(ID)) {
            return (GameBalanceConfig)d.get(ID);
        }
        return SERIALIZER;
    }

    public int getMaxLinksForLevel(int lvl) {
        if (lvl < this.link_1_lvl) {
            return 0;
        }
        if (lvl < this.link_2_lvl) {
            return 1;
        }
        if (lvl < this.link_3_lvl) {
            return 2;
        }
        if (lvl < this.link_4_lvl) {
            return 3;
        }
        if (lvl < this.link_5_lvl) {
            return 4;
        }
        return 5;
    }

    public int getNextLinkUpgradeLevel(int lvl) {
        if (lvl < this.link_1_lvl) {
            return this.link_1_lvl;
        }
        if (lvl < this.link_2_lvl) {
            return this.link_2_lvl;
        }
        if (lvl < this.link_3_lvl) {
            return this.link_3_lvl;
        }
        if (lvl < this.link_4_lvl) {
            return this.link_4_lvl;
        }
        if (lvl < this.link_5_lvl) {
            return this.link_5_lvl;
        }
        return 5;
    }

    public int getTotalLinks(int links, Player p) {
        int max = this.getMaxLinksForLevel(Load.Unit((Entity)p).getLevel());
        return MathHelper.clamp(links, 0, max);
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.GAME_BALANCE;
    }

    public String GUID() {
        return this.id;
    }

    public Class<GameBalanceConfig> getClassForSerialization() {
        return GameBalanceConfig.class;
    }

    public int Weight() {
        return 1000;
    }
}

