/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.exile_effects;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.exile_effects.EffectType;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffectInstanceData;
import com.robertx22.mine_and_slash.database.data.exile_effects.VanillaStatData;
import com.robertx22.mine_and_slash.database.data.spells.components.AttachedSpell;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.value_calc.LeveledValue;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.tags.ModTag;
import com.robertx22.mine_and_slash.tags.TagList;
import com.robertx22.mine_and_slash.tags.imp.EffectTag;
import com.robertx22.mine_and_slash.tags.imp.SpellTag;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class ExileEffect
implements JsonExileRegistry<ExileEffect>,
IAutoGson<ExileEffect>,
IAutoLocName,
IAutoLocDesc {
    public static ExileEffect SERIALIZER = new ExileEffect();
    public String id;
    public String one_of_a_kind_id = "";
    public EffectType type = EffectType.neutral;
    public int max_stacks = 1;
    public SpellTag remove_on_spell_cast = null;
    public boolean stacks_affect_stats = true;
    public transient String locName = "";
    public transient String locdesc = "";
    public TagList<EffectTag> tags = new TagList((ModTag[])new EffectTag[0]);
    public TagList<SpellTag> spell_tags = new TagList((ModTag[])new SpellTag[0]);
    public List<VanillaStatData> mc_stats = new ArrayList<VanillaStatData>();
    public List<StatMod> stats = new ArrayList<StatMod>();
    public AttachedSpell spell;

    public int getMaxCharges(EntityData data) {
        return data.maxCharges.bonus.getOrDefault(this.GUID(), 0) + this.max_stacks;
    }

    public boolean hasTag(EffectTag tag) {
        return this.tags.contains(tag);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public ResourceLocation getTexture() {
        return SlashRef.id("textures/item/mob_effects/" + this.GUID() + ".png");
    }

    public Item getEffectDisplayItem() {
        ResourceLocation id = SlashRef.id("mob_effects/" + this.GUID());
        return (Item)ForgeRegistries.ITEMS.getValue(id);
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.EXILE_EFFECT;
    }

    public String GUID() {
        return this.id;
    }

    public Class<ExileEffect> getClassForSerialization() {
        return ExileEffect.class;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.StatusEffects;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.effect." + this.GUID();
    }

    @Override
    public String locNameForLangFile() {
        return this.locName;
    }

    public void onTick(LivingEntity entity, ExileEffectInstanceData data) {
        try {
            if (entity.m_21224_()) {
                return;
            }
            if (this.spell == null) {
                return;
            }
            if (data == null) {
                return;
            }
            LivingEntity caster = data.getCaster(entity.m_9236_());
            if (caster == null) {
                return;
            }
            SpellCtx ctx = SpellCtx.onTick(caster, (Entity)entity, data.calcSpell);
            this.spell.tryActivate(Spell.DEFAULT_EN_NAME, ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<ExactStatData> getExactStats(LivingEntity caster, Spell spell, int stacks, float multi) {
        if (caster == null) {
            return Arrays.asList(new ExactStatData[0]);
        }
        return this.stats.stream().map(x -> {
            LeveledValue lvlval = new LeveledValue(0.0f, 100.0f);
            int perc = (int)lvlval.getValue(caster, spell);
            ExactStatData result = x.ToExactStat(perc, Load.Unit((Entity)caster).getLevel());
            if (stacks > 1 && this.stacks_affect_stats) {
                float inc;
                result.percentIncrease = inc = (float)(stacks - 1) * 100.0f;
                result.increaseByAddedPercent();
            }
            result.percentIncrease = 100.0f * multi - 100.0f;
            result.increaseByAddedPercent();
            return result;
        }).collect(Collectors.toList());
    }

    public List<Component> GetTooltipString(StatRangeInfo info) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Words.STATUS_EFFECT.locName().m_130946_(": ").m_7220_((Component)this.locName()).m_130940_(ChatFormatting.YELLOW));
        if (!this.stats.isEmpty()) {
            list.add((Component)Words.Stats.locName().m_7220_((Component)Words.PER_STACK.locName()).m_130940_(ChatFormatting.GREEN));
            for (StatMod stat : this.stats) {
                for (Component comp : stat.getEstimationTooltip(Load.Unit((Entity)info.player).getLevel())) {
                    list.add(comp);
                }
            }
        }
        if (this.max_stacks > 1) {
            list.add((Component)Chats.MAX_STACKS.locName(this.max_stacks));
            if (!this.stacks_affect_stats) {
                list.add((Component)Chats.STACKS_DONT_MULTIPLY_STATS.locName());
            }
        }
        List<EffectTag> tags = this.tags.getTags(EffectTag.SERIALIZER);
        MutableComponent tagtext = Words.TAGS.locName().m_7220_((Component)TooltipUtils.joinMutableComps(tags.stream().map(IAutoLocName::locName).iterator(), Gui.COMMA_SEPARATOR.locName()));
        list.add((Component)tagtext.m_130940_(ChatFormatting.YELLOW));
        list.add((Component)ExileText.emptyLine().get());
        return list;
    }

    public void onApply(LivingEntity entity) {
        try {
            ExileEffectInstanceData data = this.getSavedData(entity);
            if (data != null) {
                int stacks = data.stacks;
                this.mc_stats.forEach(x -> x.applyVanillaStats(entity, stacks));
                Load.Unit((Entity)entity).setEquipsChanged();
            }
            Load.Unit((Entity)entity).setEquipsChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ExileEffectInstanceData getSavedData(LivingEntity en) {
        return Load.Unit((Entity)en).getStatusEffectsData().get(this);
    }

    public void onRemove(LivingEntity target) {
        try {
            LivingEntity caster;
            this.mc_stats.forEach(x -> x.removeVanillaStats(target));
            ExileEffectInstanceData data = this.getSavedData(target);
            if (data != null && (caster = data.getCaster(target.m_9236_())) != null && this.spell != null) {
                SpellCtx ctx = SpellCtx.onExpire(caster, (Entity)target, data.calcSpell);
                this.spell.tryActivate(Spell.DEFAULT_EN_NAME, ctx);
            }
            EntityData unitdata = Load.Unit((Entity)target);
            unitdata.getStatusEffectsData().get((ExileEffect)this).stacks = 0;
            unitdata.setEquipsChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int Weight() {
        return 1000;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return IBaseAutoLoc.AutoLocGroup.StatusEffects;
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.effect.desc." + this.GUID();
    }

    @Override
    public String locDescForLangFile() {
        return this.locdesc;
    }
}

