/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.custom_item;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.unique_items.UniqueGear;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CustomItem
implements JsonExileRegistry<CustomItem>,
IAutoGson<CustomItem> {
    public static CustomItem SERIALIZER = new CustomItem();
    public String id = "";
    public int min_lvl = 1;
    public int max_lvl = 100;
    public List<String> possible_rar = IRarity.NORMAL_GEAR_RARITIES;
    public String uniq_id = "";
    public String gear_type = "";
    public boolean disable_salvaging = false;

    public GearItemData create(Player p) {
        int lvl = Load.Unit((Entity)p).getLevel();
        int itemlvl = MathHelper.clamp(lvl, this.min_lvl, this.max_lvl);
        GearBlueprint b = new GearBlueprint(LootInfo.ofPlayer(p));
        b.level.set(itemlvl);
        GearRarity rar = (GearRarity)RandomUtils.weightedRandom((Collection)this.possible_rar.stream().map(x -> (GearRarity)ExileDB.GearRarities().get((String)x)).collect(Collectors.toList()));
        b.rarity.set(rar);
        if (!this.uniq_id.isEmpty()) {
            b.uniquePart.set((UniqueGear)ExileDB.UniqueGears().get(this.uniq_id));
        }
        if (!this.gear_type.isEmpty()) {
            b.setType(this.gear_type);
        }
        GearItemData data = b.createData();
        if (this.disable_salvaging) {
            data.data.set(GearItemData.KEYS.SALVAGING_DISABLED, true);
        }
        return data;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.CUSTOM_ITEM;
    }

    public Class<CustomItem> getClassForSerialization() {
        return CustomItem.class;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return 1000;
    }
}

