/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.currency.map;

import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.currency.base.Currency;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.gui.texts.textblocks.WorksOnBlock;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.MapBlueprint;
import com.robertx22.mine_and_slash.loot.req.DropRequirement;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MapRarityIncrease
extends Currency {
    @Override
    public WorksOnBlock.ItemType usedOn() {
        return WorksOnBlock.ItemType.MAP;
    }

    @Override
    public ItemStack internalModifyMethod(LocReqContext ctx, ItemStack stack, ItemStack currency) {
        MapItemData data = (MapItemData)StackSaving.MAP.loadFrom(stack);
        MapBlueprint b = new MapBlueprint(LootInfo.ofLevel(data.lvl));
        b.rarity.set(data.getRarity().getHigherRarity());
        MapItemData newdata = b.createData();
        newdata.uber = data.uber;
        newdata.lvl = data.lvl;
        SoundUtils.ding((Level)ctx.player.m_9236_(), (BlockPos)ctx.player.m_20183_());
        SoundUtils.playSound((Level)ctx.player.m_9236_(), (BlockPos)ctx.player.m_20183_(), (SoundEvent)SoundEvents.f_11671_, (float)1.0f, (float)1.0f);
        newdata.saveToStack(stack);
        return stack;
    }

    @Override
    public DropRequirement getDropReq() {
        return DropRequirement.Builder.of().setLevelReq((Integer)ServerContainer.get().MIN_LEVEL_MAP_DROPS.get()).build();
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(new BaseLocRequirement[0]);
    }

    @Override
    public String locDescForLangFile() {
        return "Upgrades Map Rarity. Maps with higher rarities can drop better and higher rarity gear but are also more difficult to beat.";
    }

    @Override
    public String locNameForLangFile() {
        return "Map Rarity Upgrade Orb";
    }

    public String GUID() {
        return "map_rarity_upgrade";
    }

    public int Weight() {
        return 1000;
    }

    @Override
    public ExplainedResult canItemBeModified(LocReqContext context) {
        MapItemData data = (MapItemData)StackSaving.MAP.loadFrom(context.stack);
        if (data == null) {
            return ExplainedResult.failure((Component)Chats.NOT_MAP.locName());
        }
        ExplainedResult can = this.canBeModified(data);
        if (!can.can) {
            return can;
        }
        return super.canItemBeModified(context);
    }

    public ExplainedResult canBeModified(MapItemData data) {
        if (data.rar.equals("mythic")) {
            return ExplainedResult.failure((Component)Chats.MAX_MAP_RARITY.locName());
        }
        if (!(data.getRarity().hasHigherRarity() && data.lvl >= data.getRarity().getHigherRarity().min_lvl)) {
            return ExplainedResult.failure((Component)Chats.MAX_MAP_RARITY_FOR_LVL.locName());
        }
        return ExplainedResult.success();
    }
}

