/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.currency.gear;

import com.robertx22.mine_and_slash.database.data.currency.base.GearCurrency;
import com.robertx22.mine_and_slash.database.data.currency.base.GearOutcome;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.temp.SkillItemTier;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class SharpeningStone
extends GearCurrency {
    SkillItemTier skill;
    int tier;
    public int amount;

    public SharpeningStone(SkillItemTier skill) {
        this.skill = skill;
        this.amount = (skill.tier + 1) * 2;
        this.tier = skill.tier;
    }

    @Override
    public List<GearOutcome> getOutcomes() {
        return Arrays.asList(new GearOutcome(){

            @Override
            public Words getName() {
                return Words.UpgradeQuality;
            }

            @Override
            public GearOutcome.OutcomeType getOutcomeType() {
                return GearOutcome.OutcomeType.GOOD;
            }

            @Override
            public ItemStack modify(LocReqContext ctx, GearItemData data, ItemStack stack) {
                data.data.set(GearItemData.KEYS.USED_SHARPENING_STONE, true);
                data.setQuality(data.getQuality() + SharpeningStone.this.amount);
                StackSaving.GEARS.saveTo(stack, (Object)data);
                return stack;
            }

            public int Weight() {
                return 1000;
            }
        });
    }

    @Override
    public int getPotentialLoss() {
        return 0;
    }

    @Override
    public ExplainedResult canBeModified(GearItemData data) {
        if (!data.data.get(GearItemData.KEYS.USED_SHARPENING_STONE).booleanValue()) {
            return ExplainedResult.success();
        }
        return ExplainedResult.failure((Component)Chats.THIS_ITEM_CANT_BE_USED_MORE_THAN_X_TIMES.locName(1));
    }

    @Override
    public String locDescForLangFile() {
        return "Upgrades Quality of An Item by " + this.amount + "%, can only be used once";
    }

    @Override
    public String locNameForLangFile() {
        return this.skill.word + " Sharpening Stone";
    }

    public String GUID() {
        return "sharpening_stone" + this.tier;
    }

    public int Weight() {
        return 0;
    }
}

