/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.currency.gear;

import com.robertx22.mine_and_slash.database.data.currency.base.GearCurrency;
import com.robertx22.mine_and_slash.database.data.currency.base.GearOutcome;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class QualityUpgrade
extends GearCurrency {
    @Override
    public List<GearOutcome> getOutcomes() {
        return Arrays.asList(new GearOutcome(){

            @Override
            public Words getName() {
                return Words.UpgradeQuality;
            }

            @Override
            public GearOutcome.OutcomeType getOutcomeType() {
                return GearOutcome.OutcomeType.GOOD;
            }

            @Override
            public ItemStack modify(LocReqContext ctx, GearItemData data, ItemStack stack) {
                data.setQuality(data.getQuality() + 1);
                StackSaving.GEARS.saveTo(stack, (Object)data);
                return stack;
            }

            public int Weight() {
                return 1000;
            }
        });
    }

    @Override
    public int getPotentialLoss() {
        return 0;
    }

    @Override
    public ExplainedResult canBeModified(GearItemData data) {
        if (data.getQuality() < 20) {
            return ExplainedResult.success();
        }
        return ExplainedResult.failure((Component)Chats.CANT_GO_ABOVE.locName(20));
    }

    @Override
    public String locDescForLangFile() {
        return "Upgrades Quality of An Item, quality boosts defenses.";
    }

    @Override
    public String locNameForLangFile() {
        return "Orb of Quality";
    }

    public String GUID() {
        return "orb_of_quality";
    }

    public int Weight() {
        return 1000;
    }
}

