/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.currency.base;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.database.data.currency.base.Currency;
import com.robertx22.mine_and_slash.database.data.currency.base.GearOutcome;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.gui.texts.textblocks.WorksOnBlock;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class GearCurrency
extends Currency {
    @Override
    public WorksOnBlock.ItemType usedOn() {
        return WorksOnBlock.ItemType.GEAR;
    }

    public abstract List<GearOutcome> getOutcomes();

    public abstract int getPotentialLoss();

    public boolean spendsGearPotential() {
        return this.getPotentialLoss() > 0;
    }

    @Override
    public ItemStack internalModifyMethod(LocReqContext ctx, ItemStack stack, ItemStack currency) {
        GearItemData data = (GearItemData)StackSaving.GEARS.loadFrom(stack);
        GearOutcome outcome = this.getOutcome();
        data.setPotential(data.getPotentialNumber() - this.getPotentialLoss());
        Player player = ctx.player;
        if (outcome.getOutcomeType() == GearOutcome.OutcomeType.GOOD) {
            SoundUtils.ding((Level)player.m_9236_(), (BlockPos)player.m_20183_());
            SoundUtils.playSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)SoundEvents.f_11671_, (float)1.0f, (float)1.0f);
        } else {
            SoundUtils.playSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)SoundEvents.f_11983_, (float)1.0f, (float)1.0f);
            SoundUtils.playSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)SoundEvents.f_12507_, (float)1.0f, (float)1.0f);
        }
        return outcome.modify(ctx, data, stack);
    }

    private GearOutcome getOutcome() {
        return (GearOutcome)RandomUtils.weightedRandom(this.getOutcomes());
    }

    @Override
    public ExplainedResult canItemBeModified(LocReqContext context) {
        GearItemData data = (GearItemData)StackSaving.GEARS.loadFrom(context.stack);
        if (data == null) {
            return ExplainedResult.failure((Component)Chats.NOT_GEAR.locName());
        }
        if (data.isCorrupted() && this.spendsGearPotential()) {
            return ExplainedResult.failure((Component)Chats.CORRUPT_CANT_BE_MODIFIED.locName());
        }
        if (data.getPotentialNumber() < 1 && this.spendsGearPotential()) {
            return ExplainedResult.failure((Component)Chats.GEAR_NO_POTENTIAL.locName());
        }
        ExplainedResult can = this.canBeModified(data);
        if (!can.can) {
            return can;
        }
        return super.canItemBeModified(context);
    }

    public abstract ExplainedResult canBeModified(GearItemData var1);

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(new BaseLocRequirement[0]);
    }
}

