/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.currency.base;

import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.registry.IWeighted;
import com.robertx22.mine_and_slash.database.data.currency.base.ModifyResult;
import com.robertx22.mine_and_slash.database.data.currency.base.ResultItem;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.gui.texts.textblocks.WorksOnBlock;
import com.robertx22.mine_and_slash.loot.req.DropRequirement;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.CurrencyItems;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class Currency
implements IWeighted,
IAutoLocName,
IAutoLocDesc,
IGUID,
ExileRegistry<Currency> {
    public abstract WorksOnBlock.ItemType usedOn();

    public Item getCurrencyItem() {
        return CurrencyItems.map.get(this.GUID()).get();
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return IBaseAutoLoc.AutoLocGroup.Currency_Items;
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.currency.desc." + this.GUID();
    }

    public DropRequirement getDropReq() {
        return DropRequirement.Builder.of().build();
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.CURRENCY_ITEMS;
    }

    public abstract ItemStack internalModifyMethod(LocReqContext var1, ItemStack var2, ItemStack var3);

    public abstract List<BaseLocRequirement> requirements();

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Currency_Items;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.currency." + this.GUID();
    }

    public ExplainedResult canItemBeModified(LocReqContext context) {
        for (BaseLocRequirement req : this.requirements()) {
            if (!req.isNotAllowed(context)) continue;
            return ExplainedResult.failure((Component)Component.m_237113_((String)""));
        }
        return ExplainedResult.success();
    }

    public void addToTooltip(List<Component> tooltip) {
        if (!this.requirements().isEmpty()) {
            if (Screen.m_96638_()) {
                tooltip.add((Component)TooltipUtils.color(ChatFormatting.RED, Words.Requirements.locName()));
                for (BaseLocRequirement req : this.requirements()) {
                    tooltip.add((Component)TooltipUtils.color(ChatFormatting.RED, Component.m_237113_((String)" * ").m_7220_((Component)req.getText())));
                }
            } else {
                tooltip.add((Component)TooltipUtils.color(ChatFormatting.GREEN, Words.PressShiftForRequirements.locName()));
            }
        }
    }

    public ResultItem modifyItem(LocReqContext context) {
        ExplainedResult can = context.effect.canItemBeModified(context);
        if (can.can) {
            ItemStack copy = context.stack.m_41777_();
            copy = context.effect.internalModifyMethod(context, copy, context.Currency);
            return new ResultItem(copy, ModifyResult.SUCCESS, can);
        }
        return new ResultItem(ItemStack.f_41583_, ModifyResult.NONE, can);
    }

    public static class Weights {
        public static int COMMON = 1000;
        public static int RARE = 250;
        public static int UBER = 50;
    }
}

