/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.currency;

import com.google.common.collect.ImmutableList;
import com.robertx22.library_of_exile.registry.IWeighted;
import com.robertx22.mine_and_slash.aoe_data.datapacks.models.IAutoModel;
import com.robertx22.mine_and_slash.aoe_data.datapacks.models.ItemModelManager;
import com.robertx22.mine_and_slash.database.data.currency.IItemAsCurrency;
import com.robertx22.mine_and_slash.database.data.currency.base.Currency;
import com.robertx22.mine_and_slash.database.data.currency.base.GearCurrency;
import com.robertx22.mine_and_slash.database.data.currency.base.GearOutcome;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AdditionalBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.OperationTipBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.WorksOnBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.usableitemblocks.UsageBlock;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CurrencyItem
extends Item
implements IItemAsCurrency,
IAutoLocName,
IAutoModel,
IAutoLocDesc {
    Currency effect;

    public CurrencyItem(Currency effect) {
        super(new Item.Properties());
        this.effect = effect;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ExileTooltips exileTooltips = new ExileTooltips().accept(new UsageBlock((List<? extends Component>)ImmutableList.of((Object)this.locDesc().m_130940_(ChatFormatting.AQUA)))).accept(new OperationTipBlock());
        exileTooltips.accept(WorksOnBlock.usableOn(this.effect.usedOn()));
        Currency currency = this.effect;
        if (currency instanceof GearCurrency) {
            GearCurrency gc = (GearCurrency)currency;
            List<GearOutcome> outcomes = gc.getOutcomes();
            List<MutableComponent> list = outcomes.stream().map(x -> x.getTooltip(outcomes.stream().mapToInt(IWeighted::Weight).sum()).m_130940_(ChatFormatting.GRAY)).toList();
            exileTooltips.accept(new UsageBlock(list));
            if (gc.spendsGearPotential()) {
                exileTooltips.accept(new AdditionalBlock(Collections.singletonList(Words.POTENTIAL_COST.locName(Component.m_237113_((String)("" + gc.getPotentialLoss())).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.GOLD))));
            } else {
                exileTooltips.accept(new AdditionalBlock(Collections.singletonList(Words.NOT_A_POTENTIAL_CONSUMER.locName().m_130940_(ChatFormatting.GOLD))));
            }
        }
        tooltip.addAll(exileTooltips.release());
    }

    @Override
    public Currency currencyEffect(ItemStack stack) {
        return this.effect;
    }

    @Override
    public void generateModel(ItemModelManager manager) {
        manager.generated(this);
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Currency_Items;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.effect.locNameLangFileGUID();
    }

    @Override
    public String locNameForLangFile() {
        return this.effect.locNameForLangFile();
    }

    public String GUID() {
        return this.effect.GUID();
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return this.effect.locDescGroup();
    }

    @Override
    public String locDescLangFileGUID() {
        return this.effect.locDescLangFileGUID();
    }

    @Override
    public String locDescForLangFile() {
        return this.effect.locDescForLangFile();
    }
}

