/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.content.ubers;

import com.robertx22.mine_and_slash.database.data.league.LeagueMechanic;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanics;
import com.robertx22.mine_and_slash.database.data.league.LeaguePiecesList;
import com.robertx22.mine_and_slash.database.data.league.LeagueStructure;
import com.robertx22.mine_and_slash.database.data.league.LeagueStructurePieces;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.maps.LeagueData;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.mechanics.base.LeagueBlockData;
import com.robertx22.mine_and_slash.mechanics.base.LeagueControlBlockEntity;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashBlocks;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;

public class UberMechanic
extends LeagueMechanic {
    @Override
    public LeagueStructure getStructure(MapItemData map) {
        return new LeagueStructure(this){

            @Override
            public BlockPos getTeleportPos(BlockPos pos) {
                BlockPos p = MapData.getStartChunk(pos).m_151384_(0, 0, 0);
                p = new BlockPos(p.m_123341_() + 10, this.startY() + 5 + 3, p.m_123343_() + 22);
                return p;
            }

            @Override
            public LeaguePiecesList getPieces(MapItemData map) {
                if (!map.isUber()) {
                    return new LeaguePiecesList(Arrays.asList(new LeagueStructurePieces[0]));
                }
                return map.getUber().structure;
            }

            @Override
            public int startY() {
                return 135;
            }

            @Override
            public boolean isInsideLeague(ServerLevel level, BlockPos pos) {
                return pos.m_123342_() >= this.startY() && pos.m_123342_() <= this.startY() + 30;
            }
        };
    }

    @Override
    public int getDefaultSpawns() {
        return 1;
    }

    @Override
    public void onMapStartSetup(LeagueData data) {
    }

    @Override
    public Block getTeleportBlock() {
        return SlashBlocks.UBER_TELEPORT.get();
    }

    @Override
    public float getBaseSpawnChance() {
        return 0.0f;
    }

    @Override
    public void onKillMob(MapData map, LootInfo info) {
    }

    @Override
    public void spawnMechanicInMap(ServerLevel level, BlockPos pos) {
        level.m_7731_(pos, SlashBlocks.UBER_TELEPORT.get().m_49966_(), 2);
    }

    @Override
    public void onTick(MapData map, ServerLevel level, BlockPos pos, LeagueControlBlockEntity be, LeagueBlockData data) {
    }

    @Override
    public ChatFormatting getTextColor() {
        return ChatFormatting.LIGHT_PURPLE;
    }

    @Override
    public String locNameForLangFile() {
        return "Uber Boss Mechanic";
    }

    public String GUID() {
        return LeagueMechanics.UBER_ID;
    }

    public int Weight() {
        return 0;
    }
}

