/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.forge;

import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ServerContainer {
    public static final ForgeConfigSpec spec;
    public static final ServerContainer CONTAINER;
    private static HashMap<Item, GearSlot> cachedCompatMap;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> GEAR_COMPATS;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> BANNED_ITEMS;
    public ForgeConfigSpec.BooleanValue DO_NOT_DESPAWN_MAP_MOBS;
    public ForgeConfigSpec.BooleanValue GET_STARTER_ITEMS;
    public ForgeConfigSpec.BooleanValue ENABLE_LOOT_ANNOUNCEMENTS;
    public ForgeConfigSpec.BooleanValue REQUIRE_TEAM_FOR_TEAM_DUNGEONS;
    public ForgeConfigSpec.BooleanValue DONT_SYNC_DATA_OF_AMBIENT_MOBS;
    public ForgeConfigSpec.BooleanValue MAPS_DONT_DROP_IN_MAPS;
    public ForgeConfigSpec.BooleanValue LOG_ERRORS;
    public ForgeConfigSpec.BooleanValue STOP_ERROR_SPAM;
    public ForgeConfigSpec.BooleanValue ENERGY_PENALTY;
    public ForgeConfigSpec.BooleanValue STATION_SUCK_NEARBY_CHESTS;
    public ForgeConfigSpec.IntValue MIN_LEVEL_MAP_DROPS;
    public ForgeConfigSpec.IntValue MIN_SLIME_SIZE_FOR_LOOT;
    public ForgeConfigSpec.IntValue DEATH_PENALTY_START_LEVEL;
    public ForgeConfigSpec.IntValue LEVEL_DISTANCE_PENALTY_LEEWAY;
    public ForgeConfigSpec.IntValue PERC_OFFHAND_WEP_STAT;
    public ForgeConfigSpec.IntValue DONT_MAKE_MAP_MOBS_PERSISTENT_IF_MOB_COUNT_IS_ABOVE;
    public ForgeConfigSpec.DoubleValue REGEN_HUNGER_COST;
    public ForgeConfigSpec.DoubleValue EXP_LOSS_ON_DEATH;
    public ForgeConfigSpec.DoubleValue EXP_DEBT_ON_DEATH;
    public ForgeConfigSpec.DoubleValue MAX_EXP_DEBT_MULTI;
    public ForgeConfigSpec.DoubleValue EXP_GAIN_MULTI;
    public ForgeConfigSpec.DoubleValue PARTY_RADIUS;
    public ForgeConfigSpec.DoubleValue LEVEL_DISTANCE_PENALTY_PER_LVL;
    public ForgeConfigSpec.DoubleValue LEVEL_DISTANCE_PENALTY_MIN_MULTI;
    public ForgeConfigSpec.DoubleValue EXTRA_MOB_STATS_PER_LEVEL;
    public ForgeConfigSpec.DoubleValue VANILLA_MOB_DMG_AS_EXILE_DMG;
    public ForgeConfigSpec.DoubleValue PVP_DMG_MULTI;
    public ForgeConfigSpec.DoubleValue MAX_TEAM_DISTANCE;
    public ForgeConfigSpec.DoubleValue IN_COMBAT_REGEN_MULTI;
    public ForgeConfigSpec.DoubleValue COMBAT_TO_PROFESSION_RESTED_XP_GENERATION;
    public ForgeConfigSpec.DoubleValue PROFESSION_TO_COMBAT_RESTED_XP_GENERATION;
    public ForgeConfigSpec.DoubleValue RESTED_XP_DEATH_PENALTY;
    public ForgeConfigSpec.DoubleValue UNARMED_ENERGY_COST;
    public ForgeConfigSpec.DoubleValue FAVOR_DEATH_LOSS;
    public ForgeConfigSpec.DoubleValue FAVOR_CHEST_GAIN;
    public ForgeConfigSpec.DoubleValue GEAR_DROPRATE;
    public ForgeConfigSpec.DoubleValue SOUl_DROPRATE;
    public ForgeConfigSpec.DoubleValue MAP_DROPRATE;
    public ForgeConfigSpec.DoubleValue MAP_DROPRATE_INSIDE_MAPS;
    public ForgeConfigSpec.DoubleValue GEM_DROPRATE;
    public ForgeConfigSpec.DoubleValue UBER_FRAG_DROPRATE;
    public ForgeConfigSpec.DoubleValue SKILL_GEM_DROPRATE;
    public ForgeConfigSpec.DoubleValue LOOT_CHEST_DROPRATE;
    public ForgeConfigSpec.DoubleValue SUPP_GEM_DROPRATE;
    public ForgeConfigSpec.DoubleValue AURA_GEM_DROPRATE;
    public ForgeConfigSpec.DoubleValue RUNE_DROPRATE;
    public ForgeConfigSpec.DoubleValue CURRENCY_DROPRATE;
    public ForgeConfigSpec.DoubleValue JEWEL_DROPRATE;
    public ForgeConfigSpec.DoubleValue WATCHER_EYE_DROPRATE;
    public ForgeConfigSpec.DoubleValue PROPHECY_COIN_DROPRATE;
    public ForgeConfigSpec.DoubleValue MOB_FLAT_DAMAGE_BONUS;
    public ForgeConfigSpec.DoubleValue BLOCK_COST;
    public ForgeConfigSpec.IntValue PACK_MOB_MIN;
    public ForgeConfigSpec.IntValue PACK_MOB_MAX;
    public ForgeConfigSpec.IntValue MIN_MAP_ROOMS;
    public ForgeConfigSpec.IntValue MAX_MAP_ROOMS;
    public ForgeConfigSpec.IntValue MAP_GEN_TERRAIN_RADIUS;
    public ForgeConfigSpec.IntValue MAP_GEN_MOB_RADIUS;
    public ForgeConfigSpec.IntValue PROPHECY_OFFERS_PER_REROLL;
    public ForgeConfigSpec.IntValue BONUS_EXP_PERCENT_PER_HIGHER_LVL_CHARACTERS;
    public ForgeConfigSpec.IntValue MOB_MIN;
    public ForgeConfigSpec.IntValue MOB_MAX;
    public ForgeConfigSpec.IntValue MAX_CHARACTERS;
    public ForgeConfigSpec.IntValue ITEM_LEVEL_VARIANCE;
    public ForgeConfigSpec.IntValue MOB_LEVEL_VARIANCE;

    public static ServerContainer get() {
        return CONTAINER;
    }

    ServerContainer(ForgeConfigSpec.Builder b) {
        b.comment("General Configs").push("general");
        this.ENERGY_PENALTY = b.comment("When trying to attack on low energy, you will get slow and hunger.").define("ENERGY_PENALTY", true);
        this.DO_NOT_DESPAWN_MAP_MOBS = b.define("DO_NOT_DESPAWN_MAP_MOBS", true);
        this.GET_STARTER_ITEMS = b.define("GET_STARTER_ITEMS", true);
        this.ENABLE_LOOT_ANNOUNCEMENTS = b.define("loot_announcements", true);
        this.REQUIRE_TEAM_FOR_TEAM_DUNGEONS = b.define("require_team_for_dungeons", true);
        this.DONT_SYNC_DATA_OF_AMBIENT_MOBS = b.define("dont_sync_ambient_mob_data", true);
        this.MAPS_DONT_DROP_IN_MAPS = b.define("maps_dont_drop_in_maps", false);
        this.LOG_ERRORS = b.define("log_errors", true);
        this.STOP_ERROR_SPAM = b.define("stop_error_spam", true);
        this.STATION_SUCK_NEARBY_CHESTS = b.define("STATION_SUCK_NEARBY_CHESTS", false);
        this.MIN_LEVEL_MAP_DROPS = b.defineInRange("min_level_map_drops", 10, 0, Integer.MAX_VALUE);
        this.MIN_SLIME_SIZE_FOR_LOOT = b.defineInRange("MIN_SLIME_SIZE_FOR_LOOT", 3, 0, Integer.MAX_VALUE);
        this.DEATH_PENALTY_START_LEVEL = b.defineInRange("DEATH_PENALTY_START_LEVEL", 25, 0, Integer.MAX_VALUE);
        this.LEVEL_DISTANCE_PENALTY_LEEWAY = b.defineInRange("LEVEL_DISTANCE_PENALTY_LEEWAY", 2, 0, Integer.MAX_VALUE);
        this.PERC_OFFHAND_WEP_STAT = b.defineInRange("PERC_OFFHAND_WEP_STAT", 25, 0, 100);
        this.REGEN_HUNGER_COST = b.defineInRange("regen_hunger_cost", 10.0, 0.0, 1000.0);
        this.EXP_LOSS_ON_DEATH = b.defineInRange("death_exp_penalty", 0.1, 0.0, 1.0);
        this.EXP_DEBT_ON_DEATH = b.defineInRange("death_exp_debt", 0.1, 0.0, 1.0);
        this.MAX_EXP_DEBT_MULTI = b.defineInRange("max_death_exp_debt_multi", 1.0, 0.0, 100.0);
        this.EXP_GAIN_MULTI = b.defineInRange("exp_gain_multi", 1.0, 0.0, 1000.0);
        this.PARTY_RADIUS = b.defineInRange("party_radius", 200.0, 0.0, 1000.0);
        this.LEVEL_DISTANCE_PENALTY_PER_LVL = b.defineInRange("lvl_distance_penalty_per_level", 0.1, 0.0, 1.0);
        this.LEVEL_DISTANCE_PENALTY_MIN_MULTI = b.defineInRange("min_loot_chance", 0.2, 0.0, 1.0);
        this.EXTRA_MOB_STATS_PER_LEVEL = b.defineInRange("extra_mob_stats_per_lvl", 0.02, 0.0, 1000.0);
        this.VANILLA_MOB_DMG_AS_EXILE_DMG = b.defineInRange("vanilla_mob_dmg_as_exile_dmg", 1.0, 0.0, 1000.0);
        this.PVP_DMG_MULTI = b.defineInRange("pvp_dmg_multi", 1.0, 0.0, 1000.0);
        this.MAX_TEAM_DISTANCE = b.defineInRange("max_team_distance", 75.0, 0.0, 100000.0);
        this.IN_COMBAT_REGEN_MULTI = b.defineInRange("in_combat_regen_multi", 0.5, 0.0, 10.0);
        this.COMBAT_TO_PROFESSION_RESTED_XP_GENERATION = b.defineInRange("COMBAT_TO_PROFESSION_RESTED_XP_GENERATION", 0.25, 0.0, 1.0);
        this.PROFESSION_TO_COMBAT_RESTED_XP_GENERATION = b.defineInRange("PROFESSION_TO_COMBAT_RESTED_XP_GENERATION", 0.1, 0.0, 1.0);
        this.RESTED_XP_DEATH_PENALTY = b.defineInRange("RESTED_XP_DEATH_PENALTY", 0.5, 0.0, 1.0);
        this.FAVOR_DEATH_LOSS = b.defineInRange("favor_death_loss", 50.0, 0.0, 10000.0);
        this.FAVOR_CHEST_GAIN = b.defineInRange("favor_chest_gain", 1.0, 0.0, 10000.0);
        this.GEAR_DROPRATE = b.defineInRange("gear_drop_rate", 7.0, 0.0, 1000.0);
        this.SOUl_DROPRATE = b.defineInRange("soul_drop_rate", 0.3, 0.0, 1000.0);
        this.MAP_DROPRATE = b.defineInRange("map_drop_rate", 1.0, 0.0, 1000.0);
        this.MAP_DROPRATE_INSIDE_MAPS = b.defineInRange("MAP_DROPRATE_INSIDE_MAPS", 0.5, 0.0, 1000.0);
        this.GEM_DROPRATE = b.defineInRange("gem_drop_rate", 1.0, 0.0, 1000.0);
        this.UBER_FRAG_DROPRATE = b.defineInRange("UBER_FRAG_DROPRATE", 0.02, 0.0, 1000.0);
        this.SKILL_GEM_DROPRATE = b.defineInRange("skill_gem_drop_rate", 3.0, 0.0, 1000.0);
        this.SUPP_GEM_DROPRATE = b.defineInRange("support_gem_drop_rate", 2.0, 0.0, 1000.0);
        this.AURA_GEM_DROPRATE = b.defineInRange("aura_gem_drop_rate", 2.0, 0.0, 1000.0);
        this.RUNE_DROPRATE = b.defineInRange("rune_drop_rate", 0.5, 0.0, 1000.0);
        this.CURRENCY_DROPRATE = b.defineInRange("currency_drop_rate", 1.0, 0.0, 1000.0);
        this.WATCHER_EYE_DROPRATE = b.defineInRange("WATCHER_EYE_DROPRATE", 33.0, 0.0, 1000.0);
        this.PROPHECY_COIN_DROPRATE = b.defineInRange("PROPHECY_COIN_DROPRATE", 1.0, 0.0, 1000.0);
        this.JEWEL_DROPRATE = b.defineInRange("jewel_drop_rate", 0.25, 0.0, 1000.0);
        this.LOOT_CHEST_DROPRATE = b.defineInRange("loot_chest_drop_rate", 0.1, 0.0, 1000.0);
        this.MOB_FLAT_DAMAGE_BONUS = b.defineInRange("MOB_FLAT_DAMAGE_BONUS", 6.0, 0.0, 1000.0);
        this.BLOCK_COST = b.defineInRange("block_cost", 0.25, 0.0, 1000.0);
        this.PACK_MOB_MIN = b.defineInRange("pack_mob_min", 3, 0, 20);
        this.PACK_MOB_MAX = b.defineInRange("pack_mob_max", 6, 0, 20);
        this.DONT_MAKE_MAP_MOBS_PERSISTENT_IF_MOB_COUNT_IS_ABOVE = b.defineInRange("DONT_MAKE_MAP_MOBS_PERSISTENT_IF_MOB_COUNT_IS_ABOVE", 25, 0, 10000);
        this.MAP_GEN_MOB_RADIUS = b.defineInRange("MAP_GEN_MOB_RADIUS", 1, 0, 20);
        this.MAP_GEN_TERRAIN_RADIUS = b.defineInRange("MAP_GEN_TERRAIN_RADIUS", 4, 0, 20);
        this.MIN_MAP_ROOMS = b.defineInRange("MIN_MAP_ROOMS", 12, 1, 100);
        this.MAX_MAP_ROOMS = b.defineInRange("MAX_MAP_ROOMS", 20, 1, 100);
        this.ITEM_LEVEL_VARIANCE = b.defineInRange("ITEM_LEVEL_VARIANCE", 3, 0, 100);
        this.MOB_LEVEL_VARIANCE = b.defineInRange("MOB_LEVEL_VARIANCE", 3, 0, 100);
        this.PROPHECY_OFFERS_PER_REROLL = b.defineInRange("PROPHECY_OFFERS_PER_REROLL", 18, 1, 18);
        this.MOB_MIN = b.defineInRange("mob_min", 1, 0, 20);
        this.MOB_MAX = b.defineInRange("mob_max", 2, 0, 20);
        this.BONUS_EXP_PERCENT_PER_HIGHER_LVL_CHARACTERS = b.defineInRange("BONUS_EXP_PERCENT_PER_HIGHER_LVL_CHARACTERS", 10, 0, 1000);
        this.MAX_CHARACTERS = b.defineInRange("MAX_CHARACTERS", 3, 1, 7);
        this.UNARMED_ENERGY_COST = b.defineInRange("UNARMED_ENERGY_COST", 10.0, 0.0, 100.0);
        ArrayList<String> list = new ArrayList<String>();
        list.add("minecraft:iron_sword:sword");
        this.GEAR_COMPATS = b.comment("This is for modded gear that can't be automatically recognized by the mod. If there's say a weapon like a staff in another mod, but this mod doesn't recognize it. Put it here. The usage is: modid:path:gear_slot_id. Example: minecraft:diamond_sword:sword").defineList("gear_compatibility", list, x -> {
            String str = (String)x;
            return str.split(":").length == 3;
        });
        ArrayList<String> items = new ArrayList<String>();
        items.add(VanillaUTIL.REGISTRY.items().getKey((Object)Items.f_42584_).toString());
        items.add(VanillaUTIL.REGISTRY.items().getKey((Object)Items.f_42730_).toString());
        this.BANNED_ITEMS = b.comment("Stops items from being used in maps/adventuremaps. This is used for items that allow cheesing mechanics like teleporation items mostly.").defineList("disabled_items_in_maps", items, x -> {
            String str = (String)x;
            return true;
        });
        b.pop();
    }

    public HashMap<Item, GearSlot> getCompatMap() {
        if (cachedCompatMap.isEmpty()) {
            ((List)this.GEAR_COMPATS.get()).forEach(x -> {
                try {
                    String[] array = x.split(":");
                    ResourceLocation id = new ResourceLocation(array[0], array[1]);
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                    if (item != Items.f_41852_ && item != null) {
                        if (!ExileDB.GearSlots().isRegistered(array[2])) {
                            cachedCompatMap.put(item, null);
                        } else {
                            GearSlot slot = (GearSlot)ExileDB.GearSlots().get(array[2]);
                            if (slot != null && !slot.GUID().isEmpty()) {
                                cachedCompatMap.put(item, slot);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        return cachedCompatMap;
    }

    public boolean isItemBanned(Item item) {
        String id = VanillaUTIL.REGISTRY.items().getKey((Object)item).toString();
        return ((List)this.BANNED_ITEMS.get()).stream().anyMatch(x -> x.equals(id));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerContainer::new);
        spec = (ForgeConfigSpec)specPair.getRight();
        CONTAINER = (ServerContainer)specPair.getLeft();
        cachedCompatMap = new HashMap();
    }
}

