/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.characters;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.mine_and_slash.characters.CharStorageData;
import com.robertx22.mine_and_slash.characters.CharacterData;
import com.robertx22.mine_and_slash.characters.CreateCharPacket;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class LoadCharPacket
extends MyPacket<CreateCharPacket> {
    int num;

    public LoadCharPacket(Integer num) {
        this.num = num;
    }

    public ResourceLocation getIdentifier() {
        return SlashRef.id("load_char");
    }

    public void loadFromData(FriendlyByteBuf buf) {
        this.num = buf.readInt();
    }

    public void saveToData(FriendlyByteBuf buf) {
        buf.writeInt(this.num);
    }

    public void onReceived(ExilePacketContext ctx) {
        CharacterData opt;
        CharStorageData chars = Load.player((Player)ctx.getPlayer()).characters;
        if (chars.canChangeCharactersRightNow(ctx.getPlayer()) && (opt = chars.map.get(this.num)) != null) {
            chars.load(this.num, ctx.getPlayer());
        }
    }

    public MyPacket<CreateCharPacket> newInstance() {
        return new LoadCharPacket(-1);
    }
}

