/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player.helper;

import com.robertx22.mine_and_slash.capability.player.helper.MyInventory;
import com.robertx22.mine_and_slash.database.data.stats.types.JewelSocketStat;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatCtx;
import com.robertx22.mine_and_slash.saveclasses.jewel.JewelItemData;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class JewelInvHelper
implements IStatCtx {
    public MyInventory inv;

    public JewelInvHelper(MyInventory inv) {
        this.inv = inv;
    }

    public void unequip(Player p, int i) {
        ItemStack stack = this.inv.m_8020_(i);
        if (!stack.m_41619_()) {
            PlayerUtils.giveItem(stack.m_41777_(), p);
            stack.m_41774_(100);
        }
    }

    public void socket(ItemStack stack) {
        for (int i = 0; i < this.inv.getTotalSlots(); ++i) {
            if (!this.inv.m_8020_(i).m_41619_()) continue;
            this.inv.m_6836_(i, stack.m_41777_());
        }
    }

    public int getJewelSocketsMaxStat(Player p) {
        int max = (int)Load.Unit((Entity)p).getUnit().getCalculatedStat(JewelSocketStat.getInstance()).getValue();
        return max;
    }

    public boolean hasFreeJewelSlots(Player p) {
        return this.getAllJewels().size() < this.getJewelSocketsMaxStat(p);
    }

    public void checkRemoveJewels(Player p) {
        int max = this.getJewelSocketsMaxStat(p);
        int total = 0;
        ArrayList<String> uniques = new ArrayList<String>();
        for (int i = 0; i < this.inv.getTotalSlots(); ++i) {
            ItemStack stack = this.inv.m_8020_(i);
            JewelItemData data = (JewelItemData)StackSaving.JEWEL.loadFrom(stack);
            if (data != null) {
                ++total;
                if (!data.canWear(Load.Unit((Entity)p))) {
                    this.unequip(p, i);
                }
                if (!data.uniq.id.isEmpty()) {
                    if (uniques.contains(data.uniq.id)) {
                        this.unequip(p, i);
                    } else {
                        uniques.add(data.uniq.id);
                    }
                }
                if (total <= max) continue;
                p.m_213846_((Component)Chats.YOU_LACK_JEWEL_SLOTS.locName());
                this.unequip(p, i);
                continue;
            }
            this.unequip(p, i);
        }
    }

    public List<JewelItemData> getAllJewels() {
        ArrayList<JewelItemData> list = new ArrayList<JewelItemData>();
        for (int i = 0; i < this.inv.getTotalSlots(); ++i) {
            ItemStack stack = this.inv.m_8020_(i);
            JewelItemData data = (JewelItemData)StackSaving.JEWEL.loadFrom(stack);
            if (data == null) continue;
            list.add(data);
        }
        return list;
    }

    @Override
    public List<StatContext> getStatAndContext(LivingEntity en) {
        ArrayList<StatContext> list = new ArrayList<StatContext>();
        for (JewelItemData jewel : this.getAllJewels()) {
            for (StatContext stac : jewel.getStatAndContext(en)) {
                list.add(stac);
            }
        }
        return list;
    }
}

