/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player.helper;

import com.robertx22.mine_and_slash.aoe_data.database.stats.SpellChangeStats;
import com.robertx22.mine_and_slash.capability.player.helper.MyInventory;
import com.robertx22.mine_and_slash.capability.player.helper.SocketedGem;
import com.robertx22.mine_and_slash.database.data.aura.AuraGem;
import com.robertx22.mine_and_slash.database.data.aura.AuraGems;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.types.spirit.AuraCapacity;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.SkillGemData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GemInventoryHelper {
    public static int TOTAL_AURAS = 9;
    public static int MAX_SKILL_GEMS = 8;
    public static int SUPPORT_GEMS_PER_SKILL = 5;
    public static int TOTAL_SLOTS = MAX_SKILL_GEMS * (1 + SUPPORT_GEMS_PER_SKILL);
    MyInventory inv;
    MyInventory auras;
    Player player;

    public GemInventoryHelper(Player p, MyInventory inv, MyInventory auras) {
        this.player = p;
        this.inv = inv;
        this.auras = auras;
    }

    public void removeSupportGemsIfTooMany(Player p) {
        for (int i = 0; i < MAX_SKILL_GEMS; ++i) {
            this.getHotbarGem(i).removeSupportGemsIfTooMany(p);
        }
    }

    public MyInventory getGemsInv() {
        return this.inv;
    }

    public MyInventory getAuraInv() {
        return this.auras;
    }

    public SocketedGem getHotbarGem(int hotbar) {
        try {
            int index = hotbar;
            int invindex = hotbar * (SUPPORT_GEMS_PER_SKILL + 1);
            return new SocketedGem(this.getGemsInv(), Load.player((Player)this.player).spellCastingData.getSpellData(index), invindex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SocketedGem getIndexGem(int index) {
        try {
            int invindex = index * (SUPPORT_GEMS_PER_SKILL + 1);
            return new SocketedGem(this.getGemsInv(), Load.player((Player)this.player).spellCastingData.getSpellData(index), invindex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SocketedGem getSpellGem(Spell spell) {
        for (int i = 0; i < MAX_SKILL_GEMS; ++i) {
            int index = i;
            int invindex = index * (SUPPORT_GEMS_PER_SKILL + 1);
            SocketedGem gem = this.getIndexGem(index);
            if (gem == null || gem.getSkillData() == null || gem.getSkillData().getSpell() == null || !gem.getSkillData().getSpell().GUID().equals(spell.GUID())) continue;
            return new SocketedGem(this.getGemsInv(), Load.player((Player)this.player).spellCastingData.getSpellData(index), invindex);
        }
        return null;
    }

    public List<ItemStack> getAuras() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.auras.m_6643_(); ++i) {
            list.add(this.auras.m_8020_(i));
        }
        return list;
    }

    public List<SkillGemData> getAurasGems() {
        ArrayList<SkillGemData> list = new ArrayList<SkillGemData>();
        for (ItemStack stack : this.getAuras()) {
            SkillGemData data = (SkillGemData)StackSaving.SKILL_GEM.loadFrom(stack);
            if (data == null) continue;
            list.add(data);
        }
        return list;
    }

    public int getSpiritReserved(Player p) {
        int res = 0;
        Unit data = Load.Unit((Entity)p).getUnit();
        for (SkillGemData aura : this.getAurasGems()) {
            Stat stat;
            float cost = aura.getAura().reservation * 100.0f;
            AuraGems.AuraInfo info = new AuraGems.AuraInfo(aura.getAura());
            if (SpellChangeStats.SPECIFIC_AURA_COST.has(info) && data.getCalculatedStat(stat = SpellChangeStats.SPECIFIC_AURA_COST.get(info)).isNotZero()) {
                float multi = data.getCalculatedStat(stat).getMultiplier();
                cost *= multi;
            }
            res = (int)((float)res + cost);
        }
        return res;
    }

    public int getRemainingSpirit(Player p) {
        int reserved = this.getSpiritReserved(p);
        int spirit = this.getTotalSpirit(p);
        return spirit - reserved;
    }

    public int getTotalSpirit(Player p) {
        int num = (int)Load.Unit((Entity)p).getUnit().getCalculatedStat(AuraCapacity.getInstance()).getValue();
        if (num < 1) {
            num = (int)AuraCapacity.getInstance().base;
        }
        return num;
    }

    public void removeAurasIfCantWear(Player p) {
        if (this.getAurasGems().stream().anyMatch(x -> x.getAura().min_lvl > Load.Unit((Entity)p).getLevel())) {
            for (ItemStack s : this.getAuras()) {
                PlayerUtils.giveItem(s.m_41777_(), p);
                s.m_41774_(100);
            }
            p.m_213846_((Component)Chats.TOO_LOW_LEVEL.locName());
        }
        if (this.getRemainingSpirit(p) < 0) {
            for (ItemStack s : this.getAuras()) {
                PlayerUtils.giveItem(s.m_41777_(), p);
                s.m_41774_(100);
            }
            p.m_213846_((Component)Chats.LACK_AURA_CAPACITY.locName());
        }
        if (this.hasDuplicates()) {
            for (ItemStack s : this.getAuras()) {
                PlayerUtils.giveItem(s.m_41777_(), p);
                s.m_41774_(100);
            }
            p.m_213846_((Component)Chats.NO_DUPLICATE_AURA.locName());
        }
    }

    private boolean hasDuplicates() {
        List list = this.getAurasGems().stream().map(x -> x.id).collect(Collectors.toList());
        HashSet set = new HashSet(list);
        return set.size() < list.size();
    }

    public List<StatContext> getAuraStats(LivingEntity en) {
        ArrayList<StatContext> ctx = new ArrayList<StatContext>();
        for (ItemStack stack : this.getAuras()) {
            SkillGemData data = (SkillGemData)StackSaving.SKILL_GEM.loadFrom(stack);
            if (data == null) continue;
            AuraGem aura = data.getAura();
            ctx.add(new SimpleStatCtx(StatContext.StatCtxType.AURA, aura.GetAllStats(Load.Unit((Entity)en), data)));
        }
        return ctx;
    }
}

