/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player.data;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.mine_and_slash.capability.player.data.RestedExpData;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.OnScreenMessageUtils;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PlayerProfessionsData {
    private HashMap<String, Data> map = new HashMap();

    public int getLevel(String id) {
        return this.map.getOrDefault((Object)id, (Data)new Data()).lvl;
    }

    public void setLevel(String id, int num) {
        Data data = this.map.getOrDefault(id, new Data());
        data.lvl = num;
        this.map.put(id, data);
    }

    public int getExp(String id) {
        return this.map.getOrDefault((Object)id, (Data)new Data()).exp;
    }

    public int getMaxExp(String id) {
        return this.map.getOrDefault(id, new Data()).getExpNeeded();
    }

    public void addExp(Player p, String id, int exp) {
        if (exp < 0) {
            ExileLog.get().warn("Tried to give minus profession exp!", new Object[0]);
            return;
        }
        if (!this.map.containsKey(id)) {
            this.map.put(id, new Data());
        }
        RestedExpData rested = Load.player((Player)p).rested_xp;
        rested.onGiveProfExp(exp);
        if (rested.bonusProfExp > 0) {
            int added = MathHelper.clamp(rested.bonusProfExp, 0, exp);
            rested.bonusProfExp -= added;
            exp += added;
        }
        Data data = this.map.get(id);
        data.exp += exp;
        float perc = MathHelper.clamp(1.0f * (float)this.map.get((Object)id).exp / (1.0f * (float)this.map.get(id).getExpNeeded()) * 100.0f, 0.0f, 100.0f);
        OnScreenMessageUtils.actionBar((ServerPlayer)p, Gui.EXP_GAIN_PERCENT.locName(exp, ((Profession)ExileDB.Professions().get(id)).locName(), NumberUtils.singleDigitFloat(perc)).m_130940_(ChatFormatting.GREEN));
        if (data.canLvl() && Load.Unit((Entity)p).getLevel() > data.lvl) {
            data.levelUp();
            Profession pro = (Profession)ExileDB.Professions().get(id);
            p.m_213846_((Component)Chats.PROFESSION_LEVEL_UP.locName(pro.locName(), data.lvl));
        }
    }

    private static class Data {
        public int lvl = 1;
        public int exp = 0;

        private Data() {
        }

        public int getExpNeeded() {
            return LevelUtils.getExpRequiredForLevel(this.lvl + 1);
        }

        public boolean canLvl() {
            return this.exp >= this.getExpNeeded() && this.lvl < GameBalanceConfig.get().MAX_LEVEL;
        }

        public void levelUp() {
            int needExp = this.getExpNeeded();
            while (this.exp >= needExp) {
                this.exp -= needExp;
                ++this.lvl;
                needExp = this.getExpNeeded();
            }
        }
    }
}

