/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player.data;

import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.OnScreenMessageUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class DeathFavorData {
    private float favor = 250.0f;

    public void set(Player p, float f) {
        GearRarity rar = this.getRarity();
        boolean upped = f > this.favor;
        this.favor = MathHelper.clamp(f, 0.0f, 2.1474836E9f);
        if (rar != this.getRarity()) {
            if (upped) {
                p.m_213846_((Component)Chats.FAVOR_UP.locName(this.getRarity().locName().m_130940_(this.getRarity().textFormatting())).m_130940_(ChatFormatting.GREEN));
            } else {
                p.m_213846_((Component)Chats.FAVOR_DOWN.locName(this.getRarity().locName().m_130940_(this.getRarity().textFormatting())).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public void onSecond(Player p) {
        this.set(p, this.favor + this.getRarity().getFavorGainEverySecond());
    }

    public void onDeath(Player p) {
        float loss = ((Double)ServerContainer.get().FAVOR_DEATH_LOSS.get()).floatValue();
        this.set(p, this.favor - loss);
        p.m_213846_((Component)Chats.FAVOR_DEATH_MSG.locName((int)loss).m_130940_(ChatFormatting.DARK_PURPLE));
    }

    public void onLootChest(Player p) {
        float favorGain = ((Double)ServerContainer.get().FAVOR_CHEST_GAIN.get()).floatValue();
        this.set(p, this.favor + favorGain);
        OnScreenMessageUtils.actionBar((ServerPlayer)p, Component.m_237113_((String)("+" + favorGain + " ")).m_7220_((Component)Component.m_237113_((String)("Favor (" + this.favor + ")"))).m_130940_(ChatFormatting.GREEN));
    }

    public GearRarity getRarity() {
        GearRarity rar = (GearRarity)ExileDB.GearRarities().get("common");
        while (rar.hasHigherRarity() && this.favor >= (float)rar.getHigherRarity().favor_needed) {
            rar = rar.getHigherRarity();
        }
        return rar;
    }

    public List<Component> getTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        GearRarity rar = this.getRarity();
        tooltip.add((Component)rar.locName().m_7220_((Component)Gui.Favor_In_GUI.locName()).m_130940_(rar.textFormatting()));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Gui.Current_Favor.locName((int)this.favor).m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Gui.Loot_Exp_Multiplier.locName(Float.valueOf(this.getLootExpMulti())).m_130940_(rar.textFormatting()));
        tooltip.add((Component)Component.m_237119_());
        if (this.getRarity().getFavorGainEverySecond() > 0.0f) {
            int perhour = (int)(this.getRarity().getFavorGainEverySecond() * 60.0f * 60.0f);
            tooltip.add((Component)Gui.FAVOR_REGEN_PER_HOUR.locName(this.getRarity().textFormatting() + String.valueOf(perhour)));
        }
        tooltip.add((Component)Gui.FAVOR_PER_CHEST.locName(ServerContainer.get().FAVOR_CHEST_GAIN.get()).m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Gui.FAVOR_PER_DEATH.locName(ServerContainer.get().FAVOR_DEATH_LOSS.get()).m_130940_(ChatFormatting.RED));
        return tooltip;
    }

    public ResourceLocation getTexture() {
        return SlashRef.guiId("favor/" + this.getRarity().item_tier);
    }

    public float getLootExpMulti() {
        return this.getRarity().favor_loot_multi;
    }
}

