/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player;

import com.robertx22.library_of_exile.components.ICap;
import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.packets.SyncPlayerCapToClient;
import com.robertx22.library_of_exile.utils.LoadSave;
import com.robertx22.mine_and_slash.capability.DirtySync;
import com.robertx22.mine_and_slash.capability.player.data.DeathFavorData;
import com.robertx22.mine_and_slash.capability.player.data.MiscSyncData;
import com.robertx22.mine_and_slash.capability.player.data.PlayerBuffData;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.capability.player.data.PlayerMapData;
import com.robertx22.mine_and_slash.capability.player.data.PlayerPointsData;
import com.robertx22.mine_and_slash.capability.player.data.PlayerProfessionsData;
import com.robertx22.mine_and_slash.capability.player.data.RestedExpData;
import com.robertx22.mine_and_slash.capability.player.data.StatPointsData;
import com.robertx22.mine_and_slash.capability.player.data.TeamData;
import com.robertx22.mine_and_slash.capability.player.helper.GemInventoryHelper;
import com.robertx22.mine_and_slash.capability.player.helper.JewelInvHelper;
import com.robertx22.mine_and_slash.capability.player.helper.MyInventory;
import com.robertx22.mine_and_slash.characters.CharStorageData;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatCalcInfoData;
import com.robertx22.mine_and_slash.prophecy.PlayerProphecies;
import com.robertx22.mine_and_slash.saveclasses.DeathStatsData;
import com.robertx22.mine_and_slash.saveclasses.perks.TalentsData;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellCastingData;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellSchoolsData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_calc.StatCalculation;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerData
implements ICap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "player_data");
    public static Capability<PlayerData> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerData>(){});
    final transient LazyOptional<PlayerData> supp = LazyOptional.of(() -> this);
    private static final String TEAM_DATA = "teams";
    private static final String PROPHECY = "proph";
    private static final String TALENTS_DATA = "tals";
    private static final String STAT_POINTS = "stats";
    private static final String DEATH_STATS = "death";
    private static final String GEMS = "gems";
    private static final String AURAS = "auras";
    private static final String MAP = "map";
    private static final String ASC = "asc";
    private static final String CAST = "casting";
    private static final String CONFIG = "config";
    private static final String JEWELS = "jewels";
    private static final String FAVOR = "favor";
    private static final String PROFESSIONS = "profs";
    private static final String BUFFS = "buffs";
    private static final String RESTED_XP = "rxp";
    private static final String NAME = "name";
    private static final String CHARACTERS = "chars";
    private static final String BONUS_TALENTS = "btal";
    private static final String POINTS = "points";
    private static final String MISC_INFO = "minfo";
    public DirtySync playerDataSync = new DirtySync("playerdata_sync", x -> this.syncData());
    public transient Player player;
    public transient StatCalcInfoData ctxs = new StatCalcInfoData();
    public TeamData team = new TeamData();
    public TalentsData talents = new TalentsData();
    public StatPointsData statPoints = new StatPointsData();
    public DeathStatsData deathStats = new DeathStatsData();
    public PlayerMapData map = new PlayerMapData();
    public SpellSchoolsData ascClass = new SpellSchoolsData();
    public PlayerProphecies prophecy = new PlayerProphecies();
    public SpellCastingData spellCastingData = new SpellCastingData();
    public PlayerConfigData config = new PlayerConfigData();
    public DeathFavorData favor = new DeathFavorData();
    public PlayerProfessionsData professions = new PlayerProfessionsData();
    public PlayerBuffData buff = new PlayerBuffData();
    public RestedExpData rested_xp = new RestedExpData();
    public PlayerPointsData points = new PlayerPointsData();
    public MiscSyncData miscInfo = new MiscSyncData();
    private MyInventory skillGemInv = new MyInventory(GemInventoryHelper.TOTAL_SLOTS);
    private MyInventory auraInv = new MyInventory(GemInventoryHelper.TOTAL_AURAS);
    private MyInventory jewelsInv = new MyInventory(9);
    public CharStorageData characters = new CharStorageData();
    public List<String> aurasOn = new ArrayList<String>();
    public String name = "";
    public int bonusTalents = 0;
    public int emptyMapTicks = 0;
    transient HashMap<String, Unit> spellUnits = new HashMap();

    public static PlayerData get(LivingEntity entity) {
        return (PlayerData)entity.getCapability(INSTANCE).orElse(null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public void syncToClient(Player player) {
    }

    public PlayerData(Player player) {
        this.player = player;
    }

    public JewelInvHelper getJewels() {
        return new JewelInvHelper(this.jewelsInv);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        LoadSave.Save((Object)this.team, (CompoundTag)nbt, (String)TEAM_DATA);
        LoadSave.Save((Object)this.talents, (CompoundTag)nbt, (String)TALENTS_DATA);
        LoadSave.Save((Object)this.prophecy, (CompoundTag)nbt, (String)PROPHECY);
        LoadSave.Save((Object)this.statPoints, (CompoundTag)nbt, (String)STAT_POINTS);
        LoadSave.Save((Object)this.deathStats, (CompoundTag)nbt, (String)DEATH_STATS);
        LoadSave.Save((Object)this.map, (CompoundTag)nbt, (String)MAP);
        LoadSave.Save((Object)this.ascClass, (CompoundTag)nbt, (String)ASC);
        LoadSave.Save((Object)this.spellCastingData, (CompoundTag)nbt, (String)CAST);
        LoadSave.Save((Object)this.config, (CompoundTag)nbt, (String)CONFIG);
        LoadSave.Save((Object)this.favor, (CompoundTag)nbt, (String)FAVOR);
        LoadSave.Save((Object)this.professions, (CompoundTag)nbt, (String)PROFESSIONS);
        LoadSave.Save((Object)this.buff, (CompoundTag)nbt, (String)BUFFS);
        LoadSave.Save((Object)this.rested_xp, (CompoundTag)nbt, (String)RESTED_XP);
        LoadSave.Save((Object)this.characters, (CompoundTag)nbt, (String)CHARACTERS);
        LoadSave.Save((Object)this.points, (CompoundTag)nbt, (String)POINTS);
        LoadSave.Save((Object)this.miscInfo, (CompoundTag)nbt, (String)MISC_INFO);
        nbt.m_128365_(GEMS, (Tag)this.skillGemInv.m_7927_());
        nbt.m_128365_(AURAS, (Tag)this.auraInv.m_7927_());
        nbt.m_128365_(JEWELS, (Tag)this.jewelsInv.m_7927_());
        nbt.m_128359_(NAME, this.name);
        nbt.m_128405_(BONUS_TALENTS, this.bonusTalents);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.team = PlayerData.loadOrBlank(TeamData.class, new TeamData(), nbt, TEAM_DATA, new TeamData());
        this.prophecy = PlayerData.loadOrBlank(PlayerProphecies.class, new PlayerProphecies(), nbt, PROPHECY, new PlayerProphecies());
        this.talents = PlayerData.loadOrBlank(TalentsData.class, new TalentsData(), nbt, TALENTS_DATA, new TalentsData());
        this.statPoints = PlayerData.loadOrBlank(StatPointsData.class, new StatPointsData(), nbt, STAT_POINTS, new StatPointsData());
        this.deathStats = PlayerData.loadOrBlank(DeathStatsData.class, new DeathStatsData(), nbt, DEATH_STATS, new DeathStatsData());
        this.map = PlayerData.loadOrBlank(PlayerMapData.class, new PlayerMapData(), nbt, MAP, new PlayerMapData());
        this.ascClass = PlayerData.loadOrBlank(SpellSchoolsData.class, new SpellSchoolsData(), nbt, ASC, new SpellSchoolsData());
        this.spellCastingData = PlayerData.loadOrBlank(SpellCastingData.class, new SpellCastingData(), nbt, CAST, new SpellCastingData());
        this.config = PlayerData.loadOrBlank(PlayerConfigData.class, new PlayerConfigData(), nbt, CONFIG, new PlayerConfigData());
        this.favor = PlayerData.loadOrBlank(DeathFavorData.class, new DeathFavorData(), nbt, FAVOR, new DeathFavorData());
        this.professions = PlayerData.loadOrBlank(PlayerProfessionsData.class, new PlayerProfessionsData(), nbt, PROFESSIONS, new PlayerProfessionsData());
        this.buff = PlayerData.loadOrBlank(PlayerBuffData.class, new PlayerBuffData(), nbt, BUFFS, new PlayerBuffData());
        this.rested_xp = PlayerData.loadOrBlank(RestedExpData.class, new RestedExpData(), nbt, RESTED_XP, new RestedExpData());
        this.points = PlayerData.loadOrBlank(PlayerPointsData.class, new PlayerPointsData(), nbt, POINTS, new PlayerPointsData());
        this.characters = PlayerData.loadOrBlank(CharStorageData.class, new CharStorageData(), nbt, CHARACTERS, new CharStorageData());
        this.miscInfo = PlayerData.loadOrBlank(MiscSyncData.class, new MiscSyncData(), nbt, MISC_INFO, new MiscSyncData());
        this.skillGemInv.m_7797_(nbt.m_128437_(GEMS, 10));
        this.auraInv.m_7797_(nbt.m_128437_(AURAS, 10));
        this.jewelsInv.m_7797_(nbt.m_128437_(JEWELS, 10));
        this.name = nbt.m_128461_(NAME);
        this.bonusTalents = nbt.m_128451_(BONUS_TALENTS);
        if (this.bonusTalents < 0) {
            this.bonusTalents = 0;
        }
    }

    private void syncData() {
        Packets.sendToClient((Player)this.player, (MyPacket)new SyncPlayerCapToClient(this.player, this.getCapIdForSyncing()));
    }

    public Unit getSpellUnitStats(Player p, Spell spell) {
        if (!this.spellUnits.containsKey(spell.GUID())) {
            return Load.Unit((Entity)p).getUnit();
        }
        return this.spellUnits.get(spell.GUID());
    }

    public void calcSpellUnits(List<Spell> spells, List<StatContext> stats) {
        for (Spell spell : spells) {
            this.spellUnits.put(spell.GUID(), this.getSpellStats(spell, stats));
        }
    }

    private Unit getSpellStats(Spell spell, List<StatContext> stats) {
        int key = this.spellCastingData.keyOfSpell(spell.GUID());
        Unit unit = new Unit();
        StatCalculation.calc(unit, StatCalculation.getStatsWithoutSuppGems((LivingEntity)this.player, Load.Unit((Entity)this.player), null), (LivingEntity)this.player, key, null);
        return unit;
    }

    public GemInventoryHelper getSkillGemInventory() {
        return new GemInventoryHelper(this.player, this.skillGemInv, this.auraInv);
    }

    public static <OBJ> OBJ loadOrBlank(Class theclass, OBJ newobj, CompoundTag nbt, String loc, OBJ blank) {
        try {
            Object data = LoadSave.Load((Class)theclass, newobj, (CompoundTag)nbt, (String)loc);
            if (data == null) {
                return blank;
            }
            return (OBJ)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return blank;
        }
    }

    public String getCapIdForSyncing() {
        return "rpg_player_data";
    }
}

