/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.entity;

import com.robertx22.mine_and_slash.aoe_data.database.ailments.Ailment;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.AilmentSpeed;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.Ailments;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentDuration;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentEffectStat;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentResistance;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EventBuilder;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.enumclasses.WeaponTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class EntityAilmentData {
    public HashMap<String, List<DotData>> dotMap = new HashMap();
    public HashMap<String, Float> strMap = new HashMap();
    public HashMap<String, Float> dmgMap = new HashMap();
    String lastAttacker = "";
    transient HashMap<String, UUID> idCache = new HashMap();

    public void shatterAccumulated(LivingEntity caster, LivingEntity target, Ailment ailment, Spell spell) {
        float dmg = this.dmgMap.getOrDefault(ailment.GUID(), Float.valueOf(0.0f)).floatValue();
        this.dmgMap.put(ailment.GUID(), Float.valueOf(0.0f));
        if (dmg > 0.0f) {
            EventBuilder.ofSpellDamage(caster, target, (int)dmg, spell).setupDamage(AttackType.dot, WeaponTypes.none, PlayStyle.INT).set(x -> {
                x.calcSourceEffects = false;
                x.calcTargetEffects = false;
                x.setElement(ailment.element);
                x.setisAilmentDamage(ailment);
            }).build().Activate();
        }
    }

    public void onAilmentCausingDamage(LivingEntity caster, LivingEntity target, Ailment ailment, float dmg) {
        float freeze;
        AilmentDuration dur = new AilmentDuration(ailment);
        AilmentResistance res = new AilmentResistance(ailment);
        AilmentEffectStat eff = new AilmentEffectStat(ailment);
        this.lastAttacker = caster.m_20149_();
        float speed = Load.Unit((Entity)caster).getUnit().getCalculatedStat(AilmentSpeed.INSTANCE).getMultiplier();
        dmg *= ailment.damageEffectivenessMulti;
        dmg *= Load.Unit((Entity)caster).getUnit().getCalculatedStat(eff).getMultiplier();
        dmg *= Load.Unit((Entity)target).getUnit().getCalculatedStat(res).getMultiplier();
        if (ailment.isDot) {
            float secmulti = 1.0f / ((float)ailment.durationTicks / 20.0f);
            dmg *= secmulti;
        }
        if (ailment.isDot) {
            dmg *= speed;
            int ticks = ailment.durationTicks;
            float stat = Load.Unit((Entity)caster).getUnit().getCalculatedStat(AilmentSpeed.INSTANCE).getMultiplier();
            ticks = (int)((float)ticks / stat);
            if ((ticks = (int)((float)ticks * Load.Unit((Entity)caster).getUnit().getCalculatedStat(dur).getMultiplier())) < 21) {
                ticks = 21;
            }
            if (!this.dotMap.containsKey(ailment.GUID())) {
                this.dotMap.put(ailment.GUID(), new ArrayList());
            }
            this.dotMap.get(ailment.GUID()).add(new DotData(ticks, dmg));
        } else {
            float strength = 0.0f;
            float max = Load.Unit((Entity)target).getUnit().healthData().getValue() + Load.Unit((Entity)target).getUnit().magicShieldData().getValue();
            float forFull = max * ailment.percentHealthRequiredForFullStrength;
            if (!this.strMap.containsKey(ailment.GUID())) {
                this.strMap.put(ailment.GUID(), Float.valueOf(0.0f));
            }
            if (!this.dmgMap.containsKey(ailment.GUID())) {
                this.dmgMap.put(ailment.GUID(), Float.valueOf(0.0f));
            }
            this.dmgMap.put(ailment.GUID(), Float.valueOf(this.dmgMap.get(ailment.GUID()).floatValue() + dmg));
            float add = dmg / forFull;
            strength = MathHelper.clamp(this.strMap.get(ailment.GUID()).floatValue() + add, 0.0f, 1.0f);
            strength *= Load.Unit((Entity)caster).getUnit().getCalculatedStat(eff).getMultiplier();
            this.strMap.put(ailment.GUID(), Float.valueOf(strength *= Load.Unit((Entity)target).getUnit().getCalculatedStat(res).getMultiplier()));
        }
        if (ailment.GUID().equals(Ailments.FREEZE.GUID()) && (freeze = this.strMap.getOrDefault(Ailments.FREEZE.GUID(), Float.valueOf(0.0f)).floatValue()) > 0.0f) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, Ailments.FREEZE.getSlowTier(freeze)));
        }
    }

    public void onTick(LivingEntity en) {
        for (Map.Entry<String, List<DotData>> entry : this.dotMap.entrySet()) {
            for (DotData dotData : entry.getValue()) {
                dotData.ticks -= 1.0f;
            }
        }
        if (en.f_19797_ % 20 == 0) {
            for (Map.Entry<String, Object> entry : this.strMap.entrySet()) {
                if (!(((Float)entry.getValue()).floatValue() > 0.0f)) continue;
                Ailment ail = (Ailment)ExileDB.Ailments().get(entry.getKey());
                entry.setValue(Float.valueOf(((Float)entry.getValue()).floatValue() - ((Float)entry.getValue()).floatValue() * ail.percentLostEveryXSeconds));
            }
        }
        if (en.f_19797_ % 20 == 0 && !this.dotMap.isEmpty()) {
            Player player;
            UUID id = null;
            try {
                if (!this.idCache.containsKey(this.lastAttacker) && !this.lastAttacker.isEmpty()) {
                    this.idCache.put(this.lastAttacker, UUID.fromString(this.lastAttacker));
                }
                id = this.idCache.get(this.lastAttacker);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (id != null && (player = en.m_9236_().m_46003_(id)) != null) {
                for (Map.Entry entry : this.dotMap.entrySet()) {
                    float dmg = 0.0f;
                    for (DotData d : (List)entry.getValue()) {
                        dmg += d.dmg;
                    }
                    if (!(dmg > 1.0f)) continue;
                    Ailment ailment = (Ailment)ExileDB.Ailments().get((String)entry.getKey());
                    EventBuilder.ofDamage((LivingEntity)player, en, dmg).setupDamage(AttackType.dot, WeaponTypes.none, PlayStyle.INT).set(x -> {
                        x.setElement(ailment.element);
                        x.setisAilmentDamage(ailment);
                        x.calcTargetEffects = false;
                        x.calcSourceEffects = false;
                    }).build().Activate();
                }
            }
        }
        for (List list : this.dotMap.values()) {
            list.removeIf(x -> x.ticks < 1.0f);
        }
    }

    public class DotData {
        public float ticks;
        public float dmg;

        public DotData(int ticks, float dmg) {
            this.ticks = ticks;
            this.dmg = dmg;
        }
    }
}

