/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.entity;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.aoe_data.database.boss_spell.BossSpell;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashPotions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class BossData {
    public boolean isBoss = false;
    private int castTicks = 0;
    private String spellBeingCast = "";
    private List<String> spells = new ArrayList<String>();
    private List<Float> hpTreshs = new ArrayList<Float>();
    private Long origPos = 0L;

    public void tick(LivingEntity en) {
        if (en.m_9236_().f_46443_) {
            return;
        }
        if (en.f_19797_ % 20 == 0) {
            en.m_7292_(new MobEffectInstance(SlashPotions.KNOCKBACK_RESISTANCE.get(), 200, 10));
        }
        --this.castTicks;
        if (!this.spellBeingCast.isEmpty()) {
            BossSpell spell = (BossSpell)ExileDB.BossSpells().get(this.spellBeingCast);
            if (spell != null) {
                if (this.castTicks < 0) {
                    this.spellBeingCast = "";
                    spell.onFinish(en);
                } else {
                    en.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10));
                    spell.onTick(en, this.castTicks);
                }
            }
        } else {
            float hp = en.m_21223_() / en.m_21233_();
            if (this.hpTreshs.stream().anyMatch(x -> hp < x.floatValue())) {
                this.hpTreshs.removeIf(x -> hp < x.floatValue());
                this.starCasting(en);
            }
        }
    }

    private void starCasting(LivingEntity en) {
        this.origPos = en.m_20183_().m_121878_();
        String id = (String)RandomUtils.randomFromList(this.spells);
        BossSpell spell = (BossSpell)ExileDB.BossSpells().get(id);
        this.spellBeingCast = id;
        this.castTicks = spell.castTicks();
        spell.onStart(en);
        BlockPos pos = BlockPos.m_122022_((long)this.origPos);
        en.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public void setupRandomBoss() {
        this.isBoss = true;
        this.hpTreshs = new ArrayList<Float>();
        this.hpTreshs.addAll(Arrays.asList(Float.valueOf(0.25f), Float.valueOf(0.5f), Float.valueOf(0.75f)));
        int amount = this.hpTreshs.size();
        while (this.spells.size() < amount) {
            String id = ((BossSpell)ExileDB.BossSpells().random()).GUID();
            this.spells.add(id);
        }
    }
}

