/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.datapacks.models;

import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.DirUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.world.item.Item;

public class ModelHelper {
    Item item;
    Type type;
    String tex;
    public String modelPath = "";

    public ModelHelper(Item item, Type type) {
        this.item = item;
        this.type = type;
    }

    public ModelHelper(Item item, Type type, String tex) {
        this.item = item;
        this.type = type;
        this.tex = tex;
    }

    public void generate() {
        String tex = this.getTextureString();
        if (this.tex != null) {
            tex = this.tex;
        }
        String parent = "";
        parent = this.type == Type.GENERATED ? "item/generated" : "item/handheld";
        String filecontent = this.getBaseJsonString();
        filecontent = filecontent.replace("[PARENT]", parent);
        filecontent = filecontent.replace("[TEXTURE]", tex);
        Path path = DirUtils.generatedResourcesDir();
        String reg = "assets/mmorpg/models/item/" + VanillaUTIL.REGISTRY.items().getKey((Object)this.item).m_135815_() + ".json";
        path = path.resolve(reg);
        int index = path.toString().lastIndexOf("\\");
        String withoutname = path.toString().substring(0, index + 1);
        try {
            new File(withoutname).mkdirs();
            File file = new File(path.toString());
            file.createNewFile();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(filecontent);
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getTextureString() {
        Object id = VanillaUTIL.REGISTRY.items().getKey((Object)this.item).toString();
        if (!this.modelPath.isEmpty()) {
            id = "mmorpg:" + this.modelPath;
        }
        String tex = ((String)id).replace("mmorpg:", "mmorpg:item/");
        return tex;
    }

    private String getBaseJsonString() {
        return "{\n  \"parent\": \"[PARENT]\",\n  \"textures\": {\n    \"layer0\": \"[TEXTURE]\"\n  }\n}";
    }

    public static enum Type {
        GENERATED,
        HANDHELD;

    }
}

