/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.datapacks.lang_file;

import com.google.common.collect.Lists;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.mine_and_slash.aoe_data.datapacks.lang_file.CreateLangFileUtils;
import com.robertx22.mine_and_slash.capability.player.data.PlayerBuffData;
import com.robertx22.mine_and_slash.database.data.stats.StatGuiGroup;
import com.robertx22.mine_and_slash.database.data.stats.priority.StatPriority;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatGuiGroupSection;
import com.robertx22.mine_and_slash.loot.LootModifierEnum;
import com.robertx22.mine_and_slash.tags.ModTag;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.ChestContent;
import com.robertx22.mine_and_slash.uncommon.localization.Command;
import com.robertx22.mine_and_slash.uncommon.localization.Formatter;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.DirUtils;
import com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes.GemItem;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;

public class CreateLangFile {
    public static void create() {
        ArrayList translatorGuide = Lists.newArrayList((Object[])new String[]{"This section provides guidance to translators, offering insights into internal details:", "1. Some lang lines have corresponding locale context, particularly the formatter lines. Understanding these contexts helps translators comprehend how the lang line function. Translating these lines is unnecessary.", "2. Certain lines contain line break format(\\n). translator can add/remove that format at will based on the actual length of the translated text."});
        Object json = "{\n";
        for (Iterator<Map.Entry<String, List<IAutoLocDesc>>> x : translatorGuide) {
            json = (String)json + "\t\"translator_guide_" + translatorGuide.indexOf(x) + "\": \"" + StringEscapeUtils.escapeJava((String)((Object)x)) + "\",\n";
        }
        json = (String)json + DirUtils.getManualString();
        ArrayList<String> usedGUIDS = new ArrayList<String>();
        for (Map.Entry entry : CreateLangFile.getMap().entrySet()) {
            json = (String)json + CreateLangFileUtils.comment((String)entry.getKey());
            for (IAutoLocName iAutoLocName : (List)entry.getValue()) {
                boolean bad = false;
                if (iAutoLocName.locNameLangFileGUID().isEmpty()) {
                    bad = true;
                }
                if (!iAutoLocName.shouldRegisterLangName()) {
                    bad = true;
                }
                if (iAutoLocName.locNameForLangFile() == null || iAutoLocName.locNameForLangFile().isEmpty()) {
                    bad = true;
                }
                if (bad) continue;
                if (iAutoLocName.locNameForLangFile().contains("\"")) {
                    try {
                        throw new Exception(iAutoLocName.locNameForLangFile() + " contains double \"");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (usedGUIDS.contains(iAutoLocName.formattedLocNameLangFileGUID())) continue;
                usedGUIDS.add(iAutoLocName.formattedLocNameLangFileGUID());
                if (iAutoLocName.formattedLocNameLangFileGUID().isEmpty()) continue;
                json = (String)json + "\t\"" + iAutoLocName.formattedLocNameLangFileGUID() + "\": \"" + StringEscapeUtils.escapeJava((String)iAutoLocName.locNameForLangFile()) + "\",\n";
                if (iAutoLocName.additionLocInformation() == null) continue;
                json = (String)json + "\t\"" + iAutoLocName.formattedLocNameLangFileGUID() + ".locale_context_for_translator\": \"" + StringEscapeUtils.escapeJava((String)iAutoLocName.additionLocInformation()) + "\",\n";
            }
            json = (String)json + CreateLangFileUtils.comment((String)entry.getKey());
        }
        usedGUIDS.clear();
        for (Map.Entry<String, List<IAutoLocDesc>> entry : CreateLangFile.getDescMap().entrySet()) {
            json = (String)json + CreateLangFileUtils.comment(entry.getKey());
            for (IAutoLocDesc iAutoLocDesc : entry.getValue()) {
                if (iAutoLocDesc.locDescLangFileGUID().isEmpty() || !iAutoLocDesc.shouldRegisterLangDesc() || iAutoLocDesc.locDescForLangFile() == null || iAutoLocDesc.locDescForLangFile().isEmpty()) continue;
                if (iAutoLocDesc.locDescForLangFile().contains("\"")) {
                    try {
                        throw new Exception(iAutoLocDesc.locDescForLangFile() + " contains double \"");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (usedGUIDS.contains(iAutoLocDesc.formattedLocDescLangFileGUID())) continue;
                usedGUIDS.add(iAutoLocDesc.formattedLocDescLangFileGUID());
                json = (String)json + "\t\"" + iAutoLocDesc.formattedLocDescLangFileGUID() + "\": \"" + StringEscapeUtils.escapeJava((String)iAutoLocDesc.locDescForLangFile()) + "\",\n";
            }
            json = (String)json + CreateLangFileUtils.comment(entry.getKey());
        }
        usedGUIDS.clear();
        json = (String)json + "\n}";
        json = CreateLangFileUtils.replaceLast((String)json, ",", "");
        try {
            if (!Files.exists(Paths.get(DirUtils.langFilePath(), new String[0]), new LinkOption[0])) {
                Files.createFile(Paths.get(DirUtils.langFilePath(), new String[0]), new FileAttribute[0]);
            }
            File file = new File(DirUtils.langFilePath());
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write((String)json);
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<String, List<IAutoLocName>> getMap() {
        HashSet<IAutoLocName> list = CreateLangFileUtils.getFromRegistries(IAutoLocName.class);
        for (ExileRegistryContainer exileRegistryContainer : Database.getAllRegistries()) {
            IAutoLocName loc;
            for (Object o : exileRegistryContainer.getSerializable()) {
                if (!(o instanceof IAutoLocName)) continue;
                loc = (IAutoLocName)o;
                list.add(loc);
            }
            for (Object o : exileRegistryContainer.getList()) {
                if (!(o instanceof IAutoLocName)) continue;
                loc = (IAutoLocName)o;
                list.add(loc);
            }
        }
        list.addAll(Arrays.asList(Chats.values()));
        list.addAll(Arrays.asList(Words.values()));
        list.addAll(Arrays.asList(StatGuiGroupSection.values()));
        list.addAll(Arrays.asList(Formatter.values()));
        list.addAll(Arrays.asList(Gui.values()));
        list.addAll(Arrays.asList(Itemtips.values()));
        list.addAll(Arrays.asList(StatGuiGroup.values()));
        list.addAll(Arrays.asList(Command.values()));
        for (StatPriority statPriority : StatPriority.MAP.values()) {
            list.add(statPriority);
        }
        for (Map.Entry entry : ModTag.MAP.entrySet()) {
            list.addAll((Collection)entry.getValue());
        }
        list.addAll(Arrays.asList(GemItem.GemType.values()));
        list.addAll(Arrays.asList(GemItem.GemRank.values()));
        list.addAll(Arrays.asList(PlayerBuffData.Type.values()));
        list.addAll(Arrays.asList(ChestContent.chestTypeEnum.values()));
        list.addAll(Arrays.asList(LootModifierEnum.values()));
        HashMap map = new HashMap();
        for (IBaseAutoLoc.AutoLocGroup autoLocGroup : IBaseAutoLoc.AutoLocGroup.values()) {
            map.put(autoLocGroup, list.stream().filter(x -> x.locNameGroup().equals((Object)autoLocGroup)).collect(Collectors.toList()));
        }
        HashMap<String, List<IAutoLocName>> hashMap = new HashMap<String, List<IAutoLocName>>();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<IAutoLocName> sortedlist = new ArrayList<IAutoLocName>((Collection)entry.getValue());
            CreateLangFileUtils.sortName(sortedlist);
            if (sortedlist.size() <= 0) continue;
            hashMap.put(((IAutoLocName)((List)entry.getValue()).get(0)).getGroupName(), sortedlist);
        }
        return hashMap;
    }

    public static HashMap<String, List<IAutoLocDesc>> getDescMap() {
        HashSet<IAutoLocDesc> list = CreateLangFileUtils.getFromRegistries(IAutoLocDesc.class);
        for (IBaseAutoLoc.AutoLocGroup[] reg : Database.getAllRegistries()) {
            IAutoLocDesc loc;
            for (Object o : reg.getSerializable()) {
                if (!(o instanceof IAutoLocDesc)) continue;
                loc = (IAutoLocDesc)o;
                list.add(loc);
            }
            for (Object o : reg.getList()) {
                if (!(o instanceof IAutoLocDesc)) continue;
                loc = (IAutoLocDesc)o;
                list.add(loc);
            }
        }
        HashMap map = new HashMap();
        for (IBaseAutoLoc.AutoLocGroup autoLocGroup : IBaseAutoLoc.AutoLocGroup.values()) {
            map.put(autoLocGroup, list.stream().filter(x -> x.locDescGroup().equals((Object)autoLocGroup)).collect(Collectors.toList()));
        }
        HashMap<String, List<IAutoLocDesc>> sortedMap = new HashMap<String, List<IAutoLocDesc>>();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<IAutoLocDesc> sortedlist = new ArrayList<IAutoLocDesc>((Collection)entry.getValue());
            CreateLangFileUtils.sortDesc(sortedlist);
            if (sortedlist.size() <= 0) continue;
            sortedMap.put(((IAutoLocDesc)((List)entry.getValue()).get(0)).getDescGroupName(), sortedlist);
        }
        return sortedMap;
    }
}

