/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.datapacks.generators;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.robertx22.mine_and_slash.aoe_data.database.gear_slots.GearSlots;
import com.robertx22.mine_and_slash.database.data.currency.base.IShapedRecipe;
import com.robertx22.mine_and_slash.database.data.currency.base.IShapelessRecipe;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.profession.all.ProfessionMatItems;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.mmorpg.registers.deferred_wrapper.RegObj;
import com.robertx22.mine_and_slash.vanilla_mc.items.gearitems.VanillaMaterial;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.function.Consumer;
import joptsimple.internal.Strings;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EnchantedItemTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeGenerator {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    protected Path getBasePath() {
        return FMLPaths.GAMEDIR.get();
    }

    protected Path movePath(Path target) {
        String movedpath = target.toString();
        movedpath = movedpath.replace("run", "src/generated/resources");
        return Paths.get(movedpath, new String[0]);
    }

    private Path resolve(Path path, String id) {
        return path.resolve("data/mmorpg/recipes/" + id + ".json");
    }

    protected void generateAll(CachedOutput cache) {
        Path path = this.getBasePath();
        this.generate(x -> {
            Path target = this.movePath(this.resolve(path, x.m_6445_().m_135815_()));
            DataProvider.m_253162_((CachedOutput)cache, (JsonElement)x.m_125966_(), (Path)target);
        });
    }

    private void generate(Consumer<FinishedRecipe> consumer) {
        ExileDB.CurrencyItems().getList().forEach(item -> {
            IShapelessRecipe sr;
            ShapelessRecipeBuilder srec;
            IShapedRecipe ir;
            ShapedRecipeBuilder rec;
            if (item instanceof IShapedRecipe && (rec = (ir = (IShapedRecipe)((Object)item)).getRecipe()) != null) {
                rec.m_176498_(consumer);
            }
            if (item instanceof IShapelessRecipe && (srec = (sr = (IShapelessRecipe)((Object)item)).getRecipe()) != null) {
                try {
                    srec.m_176498_(consumer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        for (Item item2 : ForgeRegistries.ITEMS) {
            IShapelessRecipe sr;
            ShapelessRecipeBuilder srec;
            IShapedRecipe ir;
            ShapedRecipeBuilder rec;
            if (item2 instanceof IShapedRecipe && (rec = (ir = (IShapedRecipe)item2).getRecipe()) != null) {
                rec.m_176498_(consumer);
            }
            if (!(item2 instanceof IShapelessRecipe) || (srec = (sr = (IShapelessRecipe)item2).getRecipe()) == null) continue;
            try {
                srec.m_176498_(consumer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RecipeGenerator.harvest(consumer);
        RecipeGenerator.gearRecipe(consumer, SlashItems.GearItems.NECKLACES, GearSlots.NECKLACE);
        RecipeGenerator.gearRecipe(consumer, SlashItems.GearItems.RINGS, GearSlots.RING);
        RecipeGenerator.gearRecipe(consumer, SlashItems.GearItems.STAFFS, GearSlots.STAFF);
        ProfessionMatItems.addDownRankRecipes(consumer);
    }

    static void harvest(Consumer<FinishedRecipe> con) {
    }

    public static void gearRecipe(Consumer<FinishedRecipe> cons, HashMap<VanillaMaterial, RegObj<Item>> map, String slot) {
        map.entrySet().forEach(x -> {
            ShapedRecipeBuilder fac = ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)((RegObj)x.getValue()).get()), (int)1);
            String[] pattern = RecipeGenerator.getRecipePattern((GearSlot)ExileDB.GearSlots().get(slot));
            String all = Strings.join((String[])pattern, (String)"");
            if (all.contains("M")) {
                if (((VanillaMaterial)((Object)((Object)x.getKey()))).mat.tag != null) {
                    fac.m_206416_(Character.valueOf('M'), ((VanillaMaterial)((Object)((Object)x.getKey()))).mat.tag);
                } else {
                    fac.m_126127_(Character.valueOf('M'), (ItemLike)((VanillaMaterial)((Object)((Object)x.getKey()))).mat.item);
                }
            }
            if (all.contains("S")) {
                fac.m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_);
            }
            if (all.contains("B")) {
                fac.m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42401_);
            }
            for (String pat : pattern) {
                try {
                    fac.m_126130_(pat);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            fac.m_126132_("player_level", (CriterionTriggerInstance)EnchantedItemTrigger.TriggerInstance.m_27696_());
            fac.m_176498_(cons);
        });
    }

    public static String[] getRecipePattern(GearSlot type) {
        String id = type.id;
        if (id.equals(GearSlots.SWORD)) {
            return new String[]{" M ", " M ", " S "};
        }
        if (id.equals(GearSlots.STAFF)) {
            return new String[]{"  M", "SM ", "SS "};
        }
        if (id.equals(GearSlots.BOW)) {
            return new String[]{" MB", "M B", " MB"};
        }
        if (id.equals(GearSlots.CROSBOW)) {
            return new String[]{"MSM", "S S", " S "};
        }
        if (id.equals(GearSlots.CHEST)) {
            return new String[]{"M M", "MMM", "MMM"};
        }
        if (id.equals(GearSlots.BOW)) {
            return new String[]{"M M", "M M"};
        }
        if (id.equals(GearSlots.PANTS)) {
            return new String[]{"MMM", "M M", "M M"};
        }
        if (id.equals(GearSlots.HELMET)) {
            return new String[]{"MMM", "M M"};
        }
        if (id.equals(GearSlots.NECKLACE)) {
            return new String[]{"MMM", "M M", "MMM"};
        }
        if (id.equals(GearSlots.RING)) {
            return new String[]{" M ", "M M", " M "};
        }
        System.out.print("NO RECIPE FOR TAG ");
        return null;
    }

    static InventoryChangeTrigger.TriggerInstance conditionsFromItem(ItemLike itemConvertible) {
        return RecipeGenerator.conditionsFromItemPredicates(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemConvertible}).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance conditionsFromItemPredicates(ItemPredicate ... itemPredicates) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, itemPredicates);
    }
}

