/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.spells.schools;

import com.robertx22.library_of_exile.registry.ExileRegistryInit;
import com.robertx22.mine_and_slash.aoe_data.database.exile_effects.adders.ModEffects;
import com.robertx22.mine_and_slash.aoe_data.database.spells.PartBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellCalcs;
import com.robertx22.mine_and_slash.database.data.spells.components.SpellConfiguration;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.AggroAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.ExileEffectAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.PositionSource;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SummonProjectileAction;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.EffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.TargetSelector;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.CastingWeapon;
import com.robertx22.mine_and_slash.database.data.value_calc.ValueCalculation;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashBlocks;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashEntities;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashPotions;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.tags.all.SpellTags;
import com.robertx22.mine_and_slash.tags.imp.SpellTag;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.DashUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.Arrays;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;

public class RangerSpells
implements ExileRegistryInit {
    public static String EXPLOSIVE_ARROW_ID = "explosive_arrow";
    public static String CHARGED_BOLT = "charged_bolt";
    public static String ARROW_STORM = "arrow_storm";
    public static String RECOIL_SHOT = "recoil_shot";
    public static String DASH_ID = "dash";
    public static String FROST_TRAP = "frost_trap";
    public static String POISON_TRAP = "poison_trap";
    public static String FIRE_TRAP = "fire_trap";
    public static String HUNTER_POTION = "hunter_potion";
    public static String SMOKE_BOMB = "smoke_bomb";
    public static String BARRAGE = "arrow_barrage";
    public static String ARROW_TOTEM = "arrow_totem";
    public static String BOOMERANG = "boomerang";
    public static String QUICKDRAW = "quickdraw";
    public static String GALE_WIND = "gale_wind";
    public static String METEOR_ARROW = "meteor_arrow";

    public void registerAll() {
        SpellBuilder.of(ARROW_TOTEM, PlayStyle.DEX, SpellConfiguration.Builder.instant(25, 10).setChargesAndRegen("arrow_totem", 3, 600), "Arrow Totem", Arrays.asList(SpellTags.projectile, SpellTags.damage, SpellTags.totem, SpellTags.PHYSICAL)).manualDesc("Summons a totem that rapidly shoots arrows, dealing " + SpellCalcs.ARROW_TOTEM.getLocDmgTooltip(Elements.Physical)).onCast(PartBuilder.playSound(SoundEvents.f_12049_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_AT_SIGHT.create(SlashEntities.SIMPLE_PROJECTILE.get(), 1.0, 0.0))).onExpire(PartBuilder.justAction(SpellAction.SUMMON_BLOCK.create(SlashBlocks.PROJECTILE_TOTEM.get(), 150.0).put(MapField.ENTITY_NAME, "block").put(MapField.BLOCK_FALL_SPEED, 0.0).put(MapField.FIND_NEAREST_SURFACE, false).put(MapField.IS_BLOCK_FALLING, false))).onTick("block", PartBuilder.groundEdgeParticles(ParticleTypes.f_123797_, 100.0, 3.0, 0.5).tick(2.0)).onTick("block", PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.create(Items.f_41852_, 1.0, 2.5, SlashEntities.SIMPLE_ARROW.get(), 40.0, false).put(MapField.ENTITY_NAME, "arrow").put(MapField.POS_SOURCE, PositionSource.SOURCE_ENTITY.name()).put(MapField.SHOOT_DIRECTION, SummonProjectileAction.ShootWay.FIND_ENEMY.name())).tick(5.0)).onTick("block", PartBuilder.playSound(SoundEvents.f_11687_, 1.0, 1.0).tick(5.0)).onExpire("arrow", PartBuilder.damageInAoe(SpellCalcs.ARROW_TOTEM, Elements.Physical, 1.5)).levelReq(20).build();
        SpellBuilder.of(BOOMERANG, PlayStyle.DEX, SpellConfiguration.Builder.instant(10, 100).setChargesAndRegen("boomerang", 3, 200).applyCastSpeedToCooldown(), "Boomerang", Arrays.asList(SpellTags.projectile, SpellTags.damage, SpellTags.chaining, SpellTags.PHYSICAL)).manualDesc("Strike enemies with a projectile that deals " + SpellCalcs.BOOMERANG.getLocDmgTooltip(Elements.Physical)).onCast(PartBuilder.playSound(SoundEvents.f_215678_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.create(SlashItems.BOOMERANG.get(), 1.0, 1.0, SlashEntities.SIMPLE_PROJECTILE.get(), 50.0, false).put(MapField.CHAIN_COUNT, 5.0))).onTick(PartBuilder.particleOnTick(1.0, ParticleTypes.f_123797_, 10.0, 0.01)).onExpire(PartBuilder.damageInAoe(SpellCalcs.BOOMERANG, Elements.Physical, 1.0)).onExpire(PartBuilder.aoeParticles(ParticleTypes.f_123797_, 50.0, 0.5)).onExpire(PartBuilder.playSound(SoundEvents.f_12514_, 1.0, 1.0)).levelReq(1).build();
        SpellBuilder.of(HUNTER_POTION, PlayStyle.DEX, SpellConfiguration.Builder.instant(0, 3600), "Hunter's Potion", Arrays.asList(SpellTags.heal)).manualDesc("Drink a potion, healing you for " + SpellCalcs.HUNTER_POTION_HEAL.getLocDmgTooltip() + " health.").weaponReq(CastingWeapon.ANY_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_11757_, 1.0, 1.0)).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123771_, 40.0, 1.5)).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123750_, 12.0, 1.5)).onCast(PartBuilder.healCaster(SpellCalcs.HUNTER_POTION_HEAL)).levelReq(10).build();
        RangerSpells.trap(FROST_TRAP, "Frost Trap", ParticleTypes.f_123754_, SpellCalcs.RANGER_TRAP, Elements.Cold).levelReq(10).build();
        RangerSpells.trap(POISON_TRAP, "Acid Trap", ParticleTypes.f_123753_, SpellCalcs.RANGER_TRAP, Elements.Shadow).levelReq(30).build();
        RangerSpells.trap(FIRE_TRAP, "Fire Trap", ParticleTypes.f_123744_, SpellCalcs.RANGER_TRAP, Elements.Fire).levelReq(1).build();
        SpellBuilder.of(SMOKE_BOMB, PlayStyle.DEX, SpellConfiguration.Builder.instant(7, 1200), "Smoke Bomb", Arrays.asList(new SpellTag[0])).manualDesc("Throw out a smoke bomb, blinding enemies and reducing threat.").weaponReq(CastingWeapon.ANY_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_12436_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.AGGRO.create(SpellCalcs.SMOKE_BOMB, AggroAction.Type.DE_AGGRO)).addActions(SpellAction.EXILE_EFFECT.create(ModEffects.BLIND.resourcePath, ExileEffectAction.GiveOrTake.GIVE_STACKS, 100.0)).addTarget(TargetSelector.AOE.create(10.0, EntityFinder.SelectionType.RADIUS, AllyOrEnemy.enemies))).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123762_, 200.0, 3.0)).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123806_, 50.0, 3.0)).levelReq(20).build();
        SpellBuilder.of(DASH_ID, PlayStyle.DEX, SpellConfiguration.Builder.instant(10, 15).setChargesAndRegen("dash", 3, 600), "Dash", Arrays.asList(SpellTags.movement, SpellTags.weapon_skill)).manualDesc("Dash forwards quickly and gain slowfall.").weaponReq(CastingWeapon.NON_MAGE_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_11837_, 1.0, 1.6).addActions(SpellAction.POTION.createGive(MobEffects.f_19591_, 20.0)).addTarget(TargetSelector.CASTER.create())).onCast(PartBuilder.playSound(SoundEvents.f_11937_, 1.0, 1.6)).teleportForward().levelReq(1).build();
        SpellBuilder.of(CHARGED_BOLT, PlayStyle.DEX, SpellConfiguration.Builder.arrowSpell(8, 300), "Charged Bolt", Arrays.asList(SpellTags.projectile, SpellTags.area, SpellTags.damage, SpellTags.LIGHTNING)).manualDesc("Shoot a slowing charged arrow that goes through enemies and deals " + SpellCalcs.CHARGED_BOLT.getLocDmgTooltip() + " " + Elements.Nature.getIconNameDmg() + " in a radius along its path.").weaponReq(CastingWeapon.RANGED).onCast(PartBuilder.playSound(SoundEvents.f_11687_, 1.0, 1.0)).onCast(PartBuilder.playSound(SoundEvents.f_11892_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.createArrow(1.0).put(MapField.PROJECTILE_SPEED, 1.0).put(MapField.EXPIRE_ON_ENTITY_HIT, false).put(MapField.GRAVITY, false))).onHit(PartBuilder.aoeParticles(ParticleTypes.f_123797_, 100.0, 1.0)).onHit(PartBuilder.playSound(SoundEvents.f_11685_, 1.0, 1.0)).onHit(PartBuilder.damageInAoe(SpellCalcs.CHARGED_BOLT, Elements.Nature, 2.0).addPerEntityHit(PartBuilder.justAction(SpellAction.POTION.createGive(MobEffects.f_19597_, 40.0)))).onTick(PartBuilder.particleOnTick(1.0, ParticleTypes.f_123797_, 4.0, 0.1)).onTick(PartBuilder.particleOnTick(1.0, ParticleTypes.f_123808_, 4.0, 0.1)).levelReq(1).build();
        SpellBuilder.of(QUICKDRAW, PlayStyle.DEX, SpellConfiguration.Builder.instant(5, 100).setChargesAndRegen("quickdraw", 3, 1200), "Quickdraw", Arrays.asList(new SpellTag[0])).manualDesc("Your bow now fires instantly, and you gain a stack of arrows if you don't have infinity.").onCast(PartBuilder.playSound(SoundEvents.f_12620_, 1.0, 1.0)).onCast(PartBuilder.giveSelfEffect(SlashPotions.INSTANT_ARROWS.get(), 200.0, 16.0)).onCast(PartBuilder.giveSelfEffect(MobEffects.f_19596_, 60.0)).onCast(PartBuilder.justAction(SpellAction.GIVE_ARROWS.create())).levelReq(10).build();
        SpellBuilder.of(ARROW_STORM, PlayStyle.DEX, SpellConfiguration.Builder.arrowSpell(20, 500), "Arrow Storm", Arrays.asList(SpellTags.projectile, SpellTags.damage, SpellTags.PHYSICAL)).weaponReq(CastingWeapon.RANGED).manualDesc("Shoot out arrows in an arc, dealing " + SpellCalcs.ARROW_STORM.getLocDmgTooltip(Elements.Physical)).onCast(PartBuilder.playSound(SoundEvents.f_11687_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.createArrow(5.0))).onHit(PartBuilder.particleOnTick(3.0, ParticleTypes.f_123796_, 3.0, 0.1)).onHit(PartBuilder.playSound(SoundEvents.f_11685_, 1.0, 1.0)).onHit(PartBuilder.damage(SpellCalcs.ARROW_STORM, Elements.Physical)).onTick(PartBuilder.particleOnTick(5.0, ParticleTypes.f_123797_, 5.0, 0.1)).levelReq(30).build();
        SpellBuilder.of(GALE_WIND, PlayStyle.DEX, SpellConfiguration.Builder.multiCast(20, 200, 10, 3), "Gale Wind", Arrays.asList(SpellTags.projectile, SpellTags.damage, SpellTags.PHYSICAL)).manualDesc("Summons multiple clouds, knocking back and dealing " + SpellCalcs.GALE_WIND.getLocDmgTooltip(Elements.Physical)).onCast(PartBuilder.playSound(SoundEvents.f_11877_, 1.0, 0.5)).onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.create(Items.f_41852_, 5.0, 0.5, SlashEntities.SIMPLE_PROJECTILE.get(), 40.0, false))).onTick(PartBuilder.particleOnTick(2.0, ParticleTypes.f_123796_, 3.0, 0.1)).onHit(PartBuilder.playSound(SoundEvents.f_11667_, 1.0, 2.0)).onHit(PartBuilder.knockback(5.0)).onHit(PartBuilder.damage(SpellCalcs.GALE_WIND, Elements.Physical)).onExpire(PartBuilder.aoeParticles(ParticleTypes.f_123796_, 5.0, 1.0)).levelReq(20).build();
        SpellBuilder.of(BARRAGE, PlayStyle.DEX, SpellConfiguration.Builder.multiCast(20, 20, 20, 10).setChargesAndRegen(BARRAGE, 3, 200), "Arrow Barrage", Arrays.asList(SpellTags.projectile, SpellTags.damage, SpellTags.PHYSICAL)).weaponReq(CastingWeapon.RANGED).manualDesc("Shoot out arrows in rapid succession, dealing " + SpellCalcs.ARROW_STORM.getLocDmgTooltip(Elements.Physical)).onCast(PartBuilder.playSound(SoundEvents.f_11687_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.createArrow(1.0))).onHit(PartBuilder.particleOnTick(3.0, ParticleTypes.f_123796_, 3.0, 0.1)).onHit(PartBuilder.playSound(SoundEvents.f_11685_, 1.0, 1.0)).onHit(PartBuilder.damage(SpellCalcs.ARROW_STORM, Elements.Physical)).onTick(PartBuilder.particleOnTick(5.0, ParticleTypes.f_123797_, 5.0, 0.1)).levelReq(1).build();
        SpellBuilder.of(EXPLOSIVE_ARROW_ID, PlayStyle.DEX, SpellConfiguration.Builder.arrowSpell(10, 200), "Explosive Arrow", Arrays.asList(SpellTags.projectile, SpellTags.damage, SpellTags.FIRE)).weaponReq(CastingWeapon.RANGED).manualDesc("Shoot an arrow that upon impact, deals " + SpellCalcs.EXPLOSIVE_ARROW.getLocDmgTooltip(Elements.Fire) + " in an area").onCast(PartBuilder.playSound(SoundEvents.f_11687_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.createArrow(1.0))).onExpire(PartBuilder.aoeParticles(ParticleTypes.f_123813_, 1.0, 0.1)).onExpire(PartBuilder.playSound(SoundEvents.f_11685_, 1.0, 1.0)).onExpire(PartBuilder.playSound(SoundEvents.f_11913_, 1.0, 1.0)).onExpire(PartBuilder.damageInAoe(SpellCalcs.EXPLOSIVE_ARROW, Elements.Fire, 2.0).addPerEntityHit(PartBuilder.justAction(SpellAction.POTION.createGive(MobEffects.f_19597_, 40.0)))).onTick(PartBuilder.particleOnTick(1.0, ParticleTypes.f_123797_, 4.0, 0.1)).levelReq(10).build();
        SpellBuilder.of(RECOIL_SHOT, PlayStyle.DEX, SpellConfiguration.Builder.arrowSpell(10, 200), "Recoil Shot", Arrays.asList(SpellTags.projectile, SpellTags.damage, SpellTags.PHYSICAL)).weaponReq(CastingWeapon.RANGED).manualDesc("Flip backwards while shooting an arrow that deals " + SpellCalcs.EXPLOSIVE_ARROW.getLocDmgTooltip(Elements.Physical) + " and applies Wounds in an area.").onCast(PartBuilder.playSound(SoundEvents.f_11687_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.createArrow(1.0))).onHit(PartBuilder.damage(SpellCalcs.DIRECT_ARROW_HIT, Elements.Physical)).onCast(PartBuilder.pushCaster(DashUtils.Way.BACKWARDS, DashUtils.Strength.MEDIUM_DISTANCE)).onHit(PartBuilder.addExileEffectToEnemiesInAoe(ModEffects.WOUNDS.resourcePath, 1.0, 400.0)).onHit(PartBuilder.playSound(SoundEvents.f_11685_, 1.0, 1.0)).onTick(PartBuilder.particleOnTick(5.0, ParticleTypes.f_123797_, 5.0, 0.1)).levelReq(10).build();
        SpellBuilder.of(METEOR_ARROW, PlayStyle.DEX, SpellConfiguration.Builder.arrowSpell(15, 10).setChargesAndRegen("meteor_arrow", 3, 200), "Meteor Arrow", Arrays.asList(SpellTags.projectile, SpellTags.area, SpellTags.damage, SpellTags.FIRE)).weaponReq(CastingWeapon.RANGED).manualDesc("Shoots an arrow that deals " + SpellCalcs.METEOR.getLocDmgTooltip(Elements.Physical) + " and summons a meteor that deals " + SpellCalcs.METEOR.getLocDmgTooltip(Elements.Fire)).onCast(PartBuilder.playSound(SoundEvents.f_11687_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.createArrow(1.0).put(MapField.ENTITY_NAME, "arrow"))).onHit("arrow", PartBuilder.damage(SpellCalcs.METEOR, Elements.Physical)).onHit("arrow", PartBuilder.playSound(SoundEvents.f_11685_, 1.0, 1.0)).onTick("arrow", PartBuilder.particleOnTick(1.0, ParticleTypes.f_123756_, 1.0, 0.1)).onTick("arrow", PartBuilder.particleOnTick(1.0, ParticleTypes.f_123744_, 1.0, 0.1)).onExpire("arrow", PartBuilder.justAction(SpellAction.SUMMON_AT_SIGHT.create(SlashEntities.SIMPLE_PROJECTILE.get(), 0.0, 7.0).put(MapField.ENTITY_NAME, "height_en").put(MapField.DISTANCE, 0.0).put(MapField.POS_SOURCE, PositionSource.SOURCE_ENTITY.name()))).onExpire("height_en", PartBuilder.justAction(SpellAction.SUMMON_BLOCK.create(Blocks.f_50450_, 200.0).put(MapField.ENTITY_NAME, "meteor").put(MapField.FIND_NEAREST_SURFACE, false).put(MapField.BLOCK_FALL_SPEED, -0.03).put(MapField.IS_BLOCK_FALLING, true))).onTick("meteor", PartBuilder.particleOnTick(2.0, ParticleTypes.f_123756_, 2.0, 0.5)).onExpire("meteor", PartBuilder.damageInAoe(SpellCalcs.METEOR, Elements.Fire, 3.0)).onExpire("meteor", PartBuilder.aoeParticles(ParticleTypes.f_123756_, 150.0, 3.0)).onExpire("meteor", PartBuilder.aoeParticles(ParticleTypes.f_123783_, 25.0, 3.0)).onExpire("meteor", PartBuilder.aoeParticles(ParticleTypes.f_123813_, 15.0, 3.0)).onExpire("meteor", PartBuilder.playSound(SoundEvents.f_11913_, 1.0, 1.0)).levelReq(20).build();
    }

    static SpellBuilder trap(String id, String name, SimpleParticleType particle, ValueCalculation dmg, Elements element) {
        return SpellBuilder.of(id, PlayStyle.DEX, SpellConfiguration.Builder.instant(7, 5).setChargesAndRegen(id, 3, 600).setSwingArm(), name, Arrays.asList(SpellTags.damage, SpellTags.area, SpellTags.trap, element.spellTag)).manualDesc("Throw out a trap that stays on the ground and activates when an enemy approaches to deal " + dmg.getLocDmgTooltip() + element.getIconNameDmg() + " in area around itself.").weaponReq(CastingWeapon.ANY_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_12473_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.create(Items.f_42416_, 1.0, 0.5, SlashEntities.SIMPLE_PROJECTILE.get(), 100.0, true))).onExpire(PartBuilder.justAction(SpellAction.SUMMON_BLOCK.create(SlashBlocks.TRAP.get(), 600.0).put(MapField.ENTITY_NAME, "trap").put(MapField.FIND_NEAREST_SURFACE, true).put(MapField.IS_BLOCK_FALLING, false))).onTick("trap", PartBuilder.aoeParticles(particle, 5.0, 1.0).addCondition(EffectCondition.IS_ENTITY_IN_RADIUS.enemiesInRadius(1.0)).addActions(SpellAction.EXPIRE.create()).addActions(SpellAction.SPECIFIC_ACTION.create("explode")).tick(2.0)).addSpecificAction("explode", PartBuilder.damageInAoe(dmg, element, 3.0)).addSpecificAction("explode", PartBuilder.aoeParticles(particle, 30.0, 3.0)).addSpecificAction("explode", PartBuilder.playSound(SoundEvents.f_11913_, 1.0, 1.0));
    }
}

