/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.spells.schools;

import com.robertx22.library_of_exile.registry.ExileRegistryInit;
import com.robertx22.mine_and_slash.aoe_data.database.exile_effects.adders.ModEffects;
import com.robertx22.mine_and_slash.aoe_data.database.spells.PartBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellCalcs;
import com.robertx22.mine_and_slash.database.data.spells.components.SpellConfiguration;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.TargetSelector;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.CastingWeapon;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashBlocks;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashEntities;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashSounds;
import com.robertx22.mine_and_slash.tags.all.SpellTags;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import java.util.Arrays;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;

public class NatureSpells
implements ExileRegistryInit {
    public static String REFRESH = "refresh";
    public static String REJUVENATION = "rejuvenation";
    public static String ENTANGLE_SEED = "entangling_seed";
    public static String POISON_CLOUD = "poison_cloud";
    public static String THORN_BUSH = "thorn_bush";
    public static String CHAOS_TOTEM = "chaos_totem";
    public static String CIRCLE_OF_HEALING = "circle_of_healing";
    public static String GARDEN_OF_THORNS = "garden_of_thorns";

    public void registerAll() {
        SpellBuilder.of(CHAOS_TOTEM, PlayStyle.STR, SpellConfiguration.Builder.instant(40, 1200), "Chaos Totem", Arrays.asList(SpellTags.area, SpellTags.damage, SpellTags.totem, SpellTags.CHAOS)).manualDesc("Summons a totem that spawns chaos meteors, dealing " + SpellCalcs.CHAOS_TOTEM.getLocDmgTooltip(Elements.Shadow) + " in an area.").onCast(PartBuilder.playSound(SoundEvents.f_12049_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_AT_SIGHT.create(SlashEntities.SIMPLE_PROJECTILE.get(), 1.0, 0.0))).onExpire(PartBuilder.justAction(SpellAction.SUMMON_BLOCK.create(SlashBlocks.PROJECTILE_TOTEM.get(), 150.0).put(MapField.ENTITY_NAME, "totem").put(MapField.BLOCK_FALL_SPEED, 0.0).put(MapField.FIND_NEAREST_SURFACE, false).put(MapField.IS_BLOCK_FALLING, false))).onTick("totem", PartBuilder.groundEdgeParticles(ParticleTypes.f_123771_, 100.0, 3.0, 0.5).tick(2.0)).onTick("totem", PartBuilder.aoeSelectEnemies(10.0, 50.0).tick(20.0).addPerEntityHit(PartBuilder.justAction(SpellAction.SUMMON_BLOCK.create(Blocks.f_50536_, 200.0).put(MapField.ENTITY_NAME, "meteor").put(MapField.BLOCK_FALL_SPEED, -0.05).put(MapField.HEIGHT, 4.0).put(MapField.FIND_NEAREST_SURFACE, false).put(MapField.IS_BLOCK_FALLING, true)))).onTick("meteor", PartBuilder.particleOnTick(1.0, ParticleTypes.f_123771_, 20.0, 0.5)).onExpire("meteor", PartBuilder.damageInAoe(SpellCalcs.CHAOS_TOTEM, Elements.Shadow, 2.0)).onExpire("meteor", PartBuilder.aoeParticles(ParticleTypes.f_123771_, 100.0, 2.0)).onExpire("meteor", PartBuilder.aoeParticles(ParticleTypes.f_123813_, 15.0, 3.0)).onExpire("meteor", PartBuilder.playSound(SoundEvents.f_11913_, 1.0, 1.0)).levelReq(20).build();
        SpellBuilder.of(THORN_BUSH, PlayStyle.INT, SpellConfiguration.Builder.instant(15, 120).setSwingArm(), "Thorn Bush", Arrays.asList(SpellTags.damage, SpellTags.area, SpellTags.totem, SpellTags.thorns, SpellTags.PHYSICAL)).manualDesc("Summon a thorny bush that deals " + SpellCalcs.THORN_BUSH.getLocDmgTooltip() + " " + Elements.Physical.getIconNameDmg() + " in an area every second and applies Thorned. Thorned enemies consume the stack of thorns every time they are basic attacked to deal " + SpellCalcs.THORN_CONSUME.getLocDmgTooltip(Elements.Physical)).onCast(PartBuilder.playSound(SoundEvents.f_11991_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_AT_SIGHT.create(SlashEntities.SIMPLE_PROJECTILE.get(), 1.0, 0.0))).onExpire(PartBuilder.justAction(SpellAction.SUMMON_BLOCK.create(SlashBlocks.THORN_BUSH.get(), 100.0).put(MapField.ENTITY_NAME, "block").put(MapField.BLOCK_FALL_SPEED, 0.0).put(MapField.FIND_NEAREST_SURFACE, true).put(MapField.IS_BLOCK_FALLING, false))).onTick("block", PartBuilder.groundEdgeParticles(ParticleTypes.f_123763_, 40.0, 3.0, 1.0)).onTick("block", PartBuilder.groundEdgeParticles(ParticleTypes.f_123753_, 40.0, 3.0, 1.0)).onTick("block", PartBuilder.damageInAoe(SpellCalcs.THORN_BUSH, Elements.Physical, 3.0).tick(20.0).noKnock()).onTick("block", PartBuilder.addExileEffectToEnemiesInAoe(ModEffects.THORN.resourcePath, 3.0, 160.0).tick(20.0)).onTick("block", PartBuilder.playSound(SoundEvents.f_11988_, 1.0, 1.0).tick(20.0)).levelReq(20).build();
        SpellBuilder.of(POISON_CLOUD, PlayStyle.INT, SpellConfiguration.Builder.instant(30, 900), "Acid Cloud", Arrays.asList(SpellTags.area, SpellTags.damage, SpellTags.CHAOS)).manualDesc("Erupt with poisonous gas, dealing " + SpellCalcs.POISON_CLOUD.getLocDmgTooltip() + " " + Elements.Shadow.getIconNameDmg() + " to nearby enemies.").weaponReq(CastingWeapon.ANY_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_12278_, 0.5, 1.0)).onCast(PartBuilder.groundParticles(ParticleTypes.f_123763_, 300.0, 5.0, 0.2)).onCast(PartBuilder.groundParticles(ParticleTypes.f_123749_, 200.0, 5.0, 0.2)).onCast(PartBuilder.damageInAoe(SpellCalcs.POISON_CLOUD, Elements.Shadow, 5.0).addPerEntityHit(PartBuilder.playSoundPerTarget(SoundEvents.f_11915_, 1.0, 1.0))).levelReq(20).build();
        SpellBuilder.of(REFRESH, PlayStyle.INT, SpellConfiguration.Builder.nonInstant(40, 3600, 20), "Refresh", Arrays.asList(SpellTags.BUFF)).manualDesc("Refreshes all your cooldowns by 1 minute.").weaponReq(CastingWeapon.ANY_WEAPON).onCast(PartBuilder.playSound(SlashSounds.FREEZE.get(), 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.REFRESH_COOLDOWNS_BY_X_TICKS.create(1200.0)).addTarget(TargetSelector.CASTER.create())).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123804_, 100.0, 1.5)).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123803_, 50.0, 1.5)).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123806_, 50.0, 1.5)).levelReq(30).build();
        SpellBuilder.of(REJUVENATION, PlayStyle.INT, SpellConfiguration.Builder.instant(15, 60), "Rejuvenation", Arrays.asList(SpellTags.heal, SpellTags.rejuvenate, SpellTags.BUFF)).manualDesc("Gives buff that heals nearby allies for " + SpellCalcs.REJUVENATION.getLocDmgTooltip() + " every second.").onCast(PartBuilder.playSound(SoundEvents.f_12049_, 1.0, 1.0)).onCast(PartBuilder.giveExileEffectToAlliesInRadius(8.0, ModEffects.REJUVENATE.resourcePath, 300.0)).levelReq(1).build();
        SpellBuilder.of(CIRCLE_OF_HEALING, PlayStyle.INT, SpellConfiguration.Builder.instant(30, 10).setChargesAndRegen(CIRCLE_OF_HEALING, 3, 600), "Circle of Healing", Arrays.asList(SpellTags.heal, SpellTags.rejuvenate)).manualDesc("Rejuvenate allies around you for " + SpellCalcs.CIRCLE_OF_HEALING.getLocDmgTooltip() + " health.").weaponReq(CastingWeapon.ANY_WEAPON).onCast(PartBuilder.playSound(SlashSounds.BUFF.get(), 1.0, 1.0)).onCast(PartBuilder.groundParticles(ParticleTypes.f_123749_, 50.0, 5.0, 0.2)).onCast(PartBuilder.groundParticles(ParticleTypes.f_123750_, 50.0, 5.0, 0.2)).onCast(PartBuilder.healInAoe(SpellCalcs.CIRCLE_OF_HEALING, 5.0)).levelReq(20).build();
        SpellBuilder.of(ENTANGLE_SEED, PlayStyle.INT, SpellConfiguration.Builder.instant(15, 1200).setSwingArm(), "Entangling Seed", Arrays.asList(SpellTags.area)).manualDesc("Throw out a seed that explodes and petrifies enemies.").onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.create(Items.f_42733_, 1.0, SlashEntities.SIMPLE_PROJECTILE.get(), 40.0))).onExpire(PartBuilder.justAction(SpellAction.EXILE_EFFECT.giveSeconds(ModEffects.PETRIFY, 5)).enemiesInRadius(3.0)).onExpire(PartBuilder.groundParticles(ParticleTypes.f_123755_, 50.0, 3.0, 0.25)).onExpire(PartBuilder.groundParticles(ParticleTypes.f_123753_, 100.0, 3.0, 0.25)).onExpire(PartBuilder.playSound(SlashSounds.STONE_CRACK.get(), 1.0, 1.0)).levelReq(10).build();
        SpellBuilder.of(GARDEN_OF_THORNS, PlayStyle.INT, SpellConfiguration.Builder.multiCast(15, 20, 20, 5).setChargesAndRegen(GARDEN_OF_THORNS, 3, 600), "Garden of Thorns", Arrays.asList(SpellTags.area, SpellTags.damage, SpellTags.thorns, SpellTags.PHYSICAL)).manualDesc("Deals " + SpellCalcs.THORN_CONSUME.getLocDmgTooltip(Elements.Physical) + " in the area and applies Thorns. Gives you Inner Calm which restores " + SpellCalcs.INNER_CALM.getLocDmgTooltip() + " Mana/s.").onCast(PartBuilder.playSound(SoundEvents.f_11991_, 1.0, 1.0)).onCast(PartBuilder.giveSelfExileEffect(ModEffects.INNER_CALM, (Double)100.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_AT_SIGHT.create(SlashEntities.SIMPLE_PROJECTILE.get(), 1.0, 7.0))).onExpire(PartBuilder.justAction(SpellAction.SUMMON_BLOCK.create(Blocks.f_50128_, 200.0).put(MapField.ENTITY_NAME, "block").put(MapField.FIND_NEAREST_SURFACE, false).put(MapField.BLOCK_FALL_SPEED, -0.02).put(MapField.IS_BLOCK_FALLING, true))).onExpire("block", PartBuilder.damageInAoe(SpellCalcs.THORN_CONSUME, Elements.Physical, 3.0).noKnock()).onExpire("block", PartBuilder.addExileEffectToEnemiesInAoe(ModEffects.THORN.resourcePath, 3.0, 200.0)).onExpire("block", PartBuilder.aoeParticles(ParticleTypes.f_123753_, 150.0, 3.0)).onExpire("block", PartBuilder.aoeParticles(ParticleTypes.f_123763_, 40.0, 3.0)).onExpire("block", PartBuilder.playSound(SoundEvents.f_11913_, 1.0, 1.0)).levelReq(20).build();
    }
}

